/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DeterminePricedCaseMixGroupCodeAndRelativeWeight
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (calculationContext.isPatientTransferred() && paymentData.getLengthOfStay() < paymentData.getAverageLengthOfStay()) {
            paymentData.setTransferPercent(BigDecimal.valueOf(paymentData.getLengthOfStay()).add(IrfPricerContext.HALF_DAY_LENGTH_OF_STAY).divide(BigDecimal.valueOf(paymentData.getAverageLengthOfStay()), 4, RoundingMode.DOWN).setScale(4, RoundingMode.HALF_UP));
            paymentData.setPricedCaseMixGroupCode(paymentData.getSubmittedCaseMixGroupCode());
            return;
        }
        if (paymentData.getLengthOfStay() <= 3) {
            paymentData.setPricedCaseMixGroupCode("A5001");
            paymentData.setCaseMixGroupRelativeWeight(calculationContext.getCmgEntry("5001").getARelativeWeight().setScale(4, RoundingMode.HALF_UP));
            return;
        }
        if (!calculationContext.isPatientExpired()) {
            paymentData.setPricedCaseMixGroupCode(paymentData.getSubmittedCaseMixGroupCode());
            return;
        }
        if (IrfPricerContext.isOrthopedicCmg(paymentData.getSubmittedCaseMixGroupCode())) {
            if (paymentData.getLengthOfStay() < 14) {
                paymentData.setPricedCaseMixGroupCode("A5101");
                paymentData.setCaseMixGroupRelativeWeight(calculationContext.getCmgEntry("5101").getARelativeWeight().setScale(4, RoundingMode.HALF_UP));
            } else {
                paymentData.setPricedCaseMixGroupCode("A5102");
                paymentData.setCaseMixGroupRelativeWeight(calculationContext.getCmgEntry("5102").getARelativeWeight().setScale(4, RoundingMode.HALF_UP));
            }
        } else if (paymentData.getLengthOfStay() < 16) {
            paymentData.setPricedCaseMixGroupCode("A5103");
            paymentData.setCaseMixGroupRelativeWeight(calculationContext.getCmgEntry("5103").getARelativeWeight().setScale(4, RoundingMode.HALF_UP));
        } else {
            paymentData.setPricedCaseMixGroupCode("A5104");
            paymentData.setCaseMixGroupRelativeWeight(calculationContext.getCmgEntry("5104").getARelativeWeight().setScale(4, RoundingMode.HALF_UP));
        }
    }
}

