/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.health.response;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.dropwizard.health.HealthEnvironment;
import io.dropwizard.health.response.HealthResponderFactory;
import io.dropwizard.health.response.HealthResponseProvider;
import io.dropwizard.health.response.ServletHealthResponder;
import io.dropwizard.jersey.setup.JerseyEnvironment;
import io.dropwizard.jetty.setup.ServletEnvironment;
import java.util.Collection;

@JsonTypeName(value="servlet")
public class ServletHealthResponderFactory
implements HealthResponderFactory {
    static final String SERVLET_SUFFIX = "-servlet";
    @JsonProperty
    private boolean cacheControlEnabled = true;
    @JsonProperty
    private String cacheControlValue = "no-store";

    public boolean isCacheControlEnabled() {
        return this.cacheControlEnabled;
    }

    public void setCacheControlEnabled(boolean cacheControlEnabled) {
        this.cacheControlEnabled = cacheControlEnabled;
    }

    public String getCacheControlValue() {
        return this.cacheControlValue;
    }

    public void setCacheControlValue(String cacheControlValue) {
        this.cacheControlValue = cacheControlValue;
    }

    @Override
    public void configure(String name, Collection<String> healthCheckUrlPaths, HealthResponseProvider healthResponseProvider, HealthEnvironment health, JerseyEnvironment jersey, ServletEnvironment servlets, ObjectMapper mapper) {
        ServletHealthResponder servlet = new ServletHealthResponder(healthResponseProvider, this.cacheControlEnabled, this.cacheControlValue);
        servlets.addServlet(name + SERVLET_SUFFIX, servlet).addMapping(healthCheckUrlPaths.toArray(new String[0]));
    }
}

