/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.logging.common;

import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import io.dropwizard.logging.common.AbstractOutputStreamAppenderFactory;
import io.dropwizard.logging.common.socket.DropwizardUdpSocketAppender;
import io.dropwizard.validation.PortRange;
import jakarta.validation.constraints.NotEmpty;

@JsonTypeName(value="udp")
public class UdpSocketAppenderFactory<E extends DeferredProcessingAware>
extends AbstractOutputStreamAppenderFactory<E> {
    @NotEmpty
    private String host = "localhost";
    @PortRange
    private int port = 514;

    @JsonProperty
    public String getHost() {
        return this.host;
    }

    @JsonProperty
    public void setHost(String host) {
        this.host = host;
    }

    @JsonProperty
    public int getPort() {
        return this.port;
    }

    @JsonProperty
    public void setPort(int port) {
        this.port = port;
    }

    @Override
    protected OutputStreamAppender<E> appender(LoggerContext context) {
        DropwizardUdpSocketAppender appender = new DropwizardUdpSocketAppender(this.host, this.port);
        appender.setContext(context);
        appender.setName("udp-socket-appender");
        return appender;
    }
}

