/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.util;

import java.util.HashSet;
import java.util.Optional;
import java.util.function.Predicate;
import org.checkerframework.checker.nullness.qual.Nullable;

public final class Throwables {
    private Throwables() {
    }

    public static Optional<Throwable> findThrowableInChain(Predicate<Throwable> condition, @Nullable Throwable t2) {
        HashSet<Throwable> seen = new HashSet<Throwable>();
        while (t2 != null && !seen.contains(t2)) {
            if (condition.test(t2)) {
                return Optional.of(t2);
            }
            seen.add(t2);
            t2 = t2.getCause();
        }
        return Optional.empty();
    }
}

