/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.web.conf;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.validation.ValidationMethod;
import io.dropwizard.web.conf.HeaderFactory;
import java.util.HashMap;
import java.util.Map;

public class CspHeaderFactory
extends HeaderFactory {
    private static final String CONTENT_SECURITY_POLICY = "Content-Security-Policy";
    private static final String CONTENT_SECURITY_POLICY_REPORT_ONLY = "Content-Security-Policy-Report-Only";
    @JsonProperty
    private String policy;
    @JsonProperty
    private String reportOnlyPolicy;

    @ValidationMethod(message="either 'policy' or 'reportOnlyPolicy' must be defined")
    @JsonIgnore
    private boolean isPolicyDefined() {
        return this.policy != null && !this.policy.isEmpty() || this.reportOnlyPolicy != null && !this.reportOnlyPolicy.isEmpty();
    }

    public String getPolicy() {
        return this.policy;
    }

    public void setPolicy(String policy) {
        this.policy = policy;
    }

    public String getReportOnlyPolicy() {
        return this.reportOnlyPolicy;
    }

    public void setReportOnlyPolicy(String reportOnlyPolicy) {
        this.reportOnlyPolicy = reportOnlyPolicy;
    }

    @Override
    protected Map<String, String> buildHeaders() {
        HashMap<String, String> headers = new HashMap<String, String>();
        if (this.policy != null) {
            headers.put(CONTENT_SECURITY_POLICY, this.policy);
        }
        if (this.reportOnlyPolicy != null) {
            headers.put(CONTENT_SECURITY_POLICY_REPORT_ONLY, this.reportOnlyPolicy);
        }
        return headers;
    }
}

