/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.text.similarity;

import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.text.similarity.SimilarityInput;
import org.apache.commons.text.similarity.SimilarityScore;

public class JaroWinklerSimilarity
implements SimilarityScore<Double> {
    static final JaroWinklerSimilarity INSTANCE = new JaroWinklerSimilarity();

    protected static int[] matches(CharSequence first, CharSequence second) {
        return JaroWinklerSimilarity.matches(SimilarityInput.input(first), SimilarityInput.input(second));
    }

    protected static <E> int[] matches(SimilarityInput<E> first, SimilarityInput<E> second) {
        int i2;
        SimilarityInput<E> min2;
        SimilarityInput<E> max;
        if (first.length() > second.length()) {
            max = first;
            min2 = second;
        } else {
            max = second;
            min2 = first;
        }
        int range = Math.max(max.length() / 2 - 1, 0);
        int[] matchIndexes = new int[min2.length()];
        Arrays.fill(matchIndexes, -1);
        boolean[] matchFlags = new boolean[max.length()];
        int matches = 0;
        block0: for (int mi = 0; mi < min2.length(); ++mi) {
            E c1 = min2.at(mi);
            int xn = Math.min(mi + range + 1, max.length());
            for (int xi = Math.max(mi - range, 0); xi < xn; ++xi) {
                if (matchFlags[xi] || !c1.equals(max.at(xi))) continue;
                matchIndexes[mi] = xi;
                matchFlags[xi] = true;
                ++matches;
                continue block0;
            }
        }
        Object[] ms1 = new Object[matches];
        Object[] ms2 = new Object[matches];
        int si = 0;
        for (i2 = 0; i2 < min2.length(); ++i2) {
            if (matchIndexes[i2] == -1) continue;
            ms1[si] = min2.at(i2);
            ++si;
        }
        si = 0;
        for (i2 = 0; i2 < max.length(); ++i2) {
            if (!matchFlags[i2]) continue;
            ms2[si] = max.at(i2);
            ++si;
        }
        int halfTranspositions = 0;
        for (int mi = 0; mi < ms1.length; ++mi) {
            if (ms1[mi].equals(ms2[mi])) continue;
            ++halfTranspositions;
        }
        int prefix = 0;
        for (int mi = 0; mi < Math.min(4, min2.length()) && first.at(mi).equals(second.at(mi)); ++mi) {
            ++prefix;
        }
        return new int[]{matches, halfTranspositions, prefix};
    }

    @Override
    public Double apply(CharSequence left, CharSequence right) {
        return this.apply(SimilarityInput.input(left), SimilarityInput.input(right));
    }

    @Override
    public <E> Double apply(SimilarityInput<E> left, SimilarityInput<E> right) {
        double defaultScalingFactor = 0.1;
        if (left == null || right == null) {
            throw new IllegalArgumentException("CharSequences must not be null");
        }
        if (Objects.equals(left, right)) {
            return 1.0;
        }
        int[] mtp = JaroWinklerSimilarity.matches(left, right);
        double m4 = mtp[0];
        if (m4 == 0.0) {
            return 0.0;
        }
        double j = (m4 / (double)left.length() + m4 / (double)right.length() + (m4 - (double)mtp[1] / 2.0) / m4) / 3.0;
        return j < 0.7 ? j : j + 0.1 * (double)mtp[2] * (1.0 - j);
    }
}

