/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api.recursive.comparison;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.BiPredicate;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.assertj.core.api.recursive.comparison.DualValue;
import org.assertj.core.api.recursive.comparison.FieldComparators;
import org.assertj.core.api.recursive.comparison.FieldLocation;
import org.assertj.core.configuration.ConfigurationProvider;
import org.assertj.core.internal.Objects;
import org.assertj.core.internal.TypeComparators;
import org.assertj.core.presentation.Representation;
import org.assertj.core.util.Lists;
import org.assertj.core.util.Sets;
import org.assertj.core.util.Strings;
import org.assertj.core.util.VisibleForTesting;
import org.assertj.core.util.introspection.PropertyOrFieldSupport;

public class RecursiveComparisonConfiguration {
    private static final String DEFAULT_DELIMITER = ", ";
    private static final boolean DEFAULT_IGNORE_ALL_OVERRIDDEN_EQUALS = true;
    public static final String INDENT_LEVEL_2 = "  -";
    private boolean strictTypeChecking = false;
    private boolean ignoreAllActualNullFields = false;
    private boolean ignoreAllActualEmptyOptionalFields = false;
    private boolean ignoreAllExpectedNullFields = false;
    private Set<String> ignoredFields = new LinkedHashSet<String>();
    private List<Pattern> ignoredFieldsRegexes = new ArrayList<Pattern>();
    private Set<Class<?>> ignoredTypes = new LinkedHashSet();
    private Set<String> comparedFields = new LinkedHashSet<String>();
    private List<Class<?>> ignoredOverriddenEqualsForTypes = new ArrayList();
    private List<String> ignoredOverriddenEqualsForFields = new ArrayList<String>();
    private List<Pattern> ignoredOverriddenEqualsForFieldsMatchingRegexes = new ArrayList<Pattern>();
    private boolean ignoreAllOverriddenEquals = true;
    private boolean ignoreCollectionOrder = false;
    private Set<String> ignoredCollectionOrderInFields = new LinkedHashSet<String>();
    private List<Pattern> ignoredCollectionOrderInFieldsMatchingRegexes = new ArrayList<Pattern>();
    private TypeComparators typeComparators = TypeComparators.defaultTypeComparators();
    private FieldComparators fieldComparators = new FieldComparators();

    private RecursiveComparisonConfiguration(Builder builder) {
        this.strictTypeChecking = builder.strictTypeChecking;
        this.ignoreAllActualNullFields = builder.ignoreAllActualNullFields;
        this.ignoreAllActualEmptyOptionalFields = builder.ignoreAllActualEmptyOptionalFields;
        this.ignoreAllExpectedNullFields = builder.ignoreAllExpectedNullFields;
        this.ignoredFields = Sets.newLinkedHashSet(builder.ignoredFields);
        this.comparedFields = Sets.newLinkedHashSet(builder.comparedFields);
        this.ignoreFieldsMatchingRegexes(builder.ignoredFieldsMatchingRegexes);
        this.ignoreFieldsOfTypes(builder.ignoredTypes);
        this.ignoreOverriddenEqualsForTypes(builder.ignoredOverriddenEqualsForTypes);
        this.ignoredOverriddenEqualsForFields = Lists.list(builder.ignoredOverriddenEqualsForFields);
        this.ignoreOverriddenEqualsForFieldsMatchingRegexes(builder.ignoredOverriddenEqualsForFieldsMatchingRegexes);
        this.ignoreAllOverriddenEquals = builder.ignoreAllOverriddenEquals;
        this.ignoreCollectionOrder = builder.ignoreCollectionOrder;
        this.ignoredCollectionOrderInFields = Sets.newLinkedHashSet(builder.ignoredCollectionOrderInFields);
        this.ignoreCollectionOrderInFieldsMatchingRegexes(builder.ignoredCollectionOrderInFieldsMatchingRegexes);
        this.typeComparators = builder.typeComparators;
        this.fieldComparators = builder.fieldComparators;
    }

    public RecursiveComparisonConfiguration() {
    }

    public boolean hasComparatorForField(String fieldName) {
        return this.fieldComparators.hasComparatorForField(fieldName);
    }

    public Comparator<?> getComparatorForField(String fieldName) {
        return this.fieldComparators.getComparatorForField(fieldName);
    }

    public FieldComparators getFieldComparators() {
        return this.fieldComparators;
    }

    public boolean hasComparatorForType(Class<?> keyType) {
        return this.typeComparators.hasComparatorForType(keyType);
    }

    public boolean hasCustomComparators() {
        return !this.typeComparators.isEmpty() || !this.fieldComparators.isEmpty();
    }

    public Comparator<?> getComparatorForType(Class<?> fieldType) {
        return this.typeComparators.get(fieldType);
    }

    public TypeComparators getTypeComparators() {
        return this.typeComparators;
    }

    Stream<Map.Entry<Class<?>, Comparator<?>>> comparatorByTypes() {
        return this.typeComparators.comparatorByTypes();
    }

    @VisibleForTesting
    boolean getIgnoreAllActualNullFields() {
        return this.ignoreAllActualNullFields;
    }

    @VisibleForTesting
    boolean getIgnoreAllExpectedNullFields() {
        return this.ignoreAllExpectedNullFields;
    }

    @VisibleForTesting
    boolean getIgnoreAllOverriddenEquals() {
        return this.ignoreAllOverriddenEquals;
    }

    public void setIgnoreAllActualEmptyOptionalFields(boolean ignoringAllActualEmptyOptionalFields) {
        this.ignoreAllActualEmptyOptionalFields = ignoringAllActualEmptyOptionalFields;
    }

    @VisibleForTesting
    boolean getIgnoreAllActualEmptyOptionalFields() {
        return this.ignoreAllActualEmptyOptionalFields;
    }

    public void setIgnoreAllActualNullFields(boolean ignoreAllActualNullFields) {
        this.ignoreAllActualNullFields = ignoreAllActualNullFields;
    }

    public void setIgnoreAllExpectedNullFields(boolean ignoreAllExpectedNullFields) {
        this.ignoreAllExpectedNullFields = ignoreAllExpectedNullFields;
    }

    public void ignoreFields(String ... fieldsToIgnore) {
        List<String> fieldLocations = Lists.list(fieldsToIgnore);
        this.ignoredFields.addAll(fieldLocations);
    }

    public void compareOnlyFields(String ... fieldNamesToCompare) {
        List<String> fieldLocations = Lists.list(fieldNamesToCompare);
        this.comparedFields.addAll(fieldLocations);
    }

    public void ignoreFieldsMatchingRegexes(String ... regexes) {
        List patterns = Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList());
        this.ignoredFieldsRegexes.addAll(patterns);
    }

    public void ignoreFieldsOfTypes(Class<?> ... types) {
        Arrays.stream(types).map(RecursiveComparisonConfiguration::asWrapperIfPrimitiveType).forEach(this.ignoredTypes::add);
    }

    private static Class<?> asWrapperIfPrimitiveType(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type.equals(Boolean.TYPE)) {
            return Boolean.class;
        }
        if (type.equals(Byte.TYPE)) {
            return Byte.class;
        }
        if (type.equals(Integer.TYPE)) {
            return Integer.class;
        }
        if (type.equals(Short.TYPE)) {
            return Short.class;
        }
        if (type.equals(Character.TYPE)) {
            return Character.class;
        }
        if (type.equals(Float.TYPE)) {
            return Float.class;
        }
        if (type.equals(Double.TYPE)) {
            return Double.class;
        }
        return type;
    }

    public Set<String> getIgnoredFields() {
        return this.ignoredFields;
    }

    public Set<String> getComparedFields() {
        return this.comparedFields;
    }

    public Set<Class<?>> getIgnoredTypes() {
        return this.ignoredTypes;
    }

    public void ignoreAllOverriddenEquals() {
        this.ignoreAllOverriddenEquals = true;
    }

    public void useOverriddenEquals() {
        this.ignoreAllOverriddenEquals = false;
    }

    public void ignoreOverriddenEqualsForFields(String ... fields) {
        List<String> fieldLocations = Lists.list(fields);
        this.ignoredOverriddenEqualsForFields.addAll(fieldLocations);
    }

    public void ignoreOverriddenEqualsForFieldsMatchingRegexes(String ... regexes) {
        this.ignoredOverriddenEqualsForFieldsMatchingRegexes.addAll(Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList()));
    }

    public void ignoreOverriddenEqualsForTypes(Class<?> ... types) {
        this.ignoredOverriddenEqualsForTypes.addAll(Lists.list(types));
    }

    @VisibleForTesting
    boolean getIgnoreCollectionOrder() {
        return this.ignoreCollectionOrder;
    }

    public void ignoreCollectionOrder(boolean ignoreCollectionOrder) {
        this.ignoreCollectionOrder = ignoreCollectionOrder;
    }

    public void ignoreCollectionOrderInFields(String ... fieldsToIgnoreCollectionOrder) {
        List<String> fieldLocations = Lists.list(fieldsToIgnoreCollectionOrder);
        this.ignoredCollectionOrderInFields.addAll(fieldLocations);
    }

    public Set<String> getIgnoredCollectionOrderInFields() {
        return this.ignoredCollectionOrderInFields;
    }

    public void ignoreCollectionOrderInFieldsMatchingRegexes(String ... regexes) {
        this.ignoredCollectionOrderInFieldsMatchingRegexes.addAll(Stream.of(regexes).map(Pattern::compile).collect(Collectors.toList()));
    }

    public List<Pattern> getIgnoredCollectionOrderInFieldsMatchingRegexes() {
        return this.ignoredCollectionOrderInFieldsMatchingRegexes;
    }

    public <T> void registerComparatorForType(Comparator<? super T> comparator, Class<T> type) {
        java.util.Objects.requireNonNull(comparator, "Expecting a non null Comparator");
        this.typeComparators.put(type, comparator);
    }

    public <T> void registerEqualsForType(BiPredicate<? super T, ? super T> equals, Class<T> type) {
        this.registerComparatorForType(RecursiveComparisonConfiguration.toComparator(equals), type);
    }

    public void registerComparatorForFields(Comparator<?> comparator, String ... fieldLocations) {
        java.util.Objects.requireNonNull(comparator, "Expecting a non null Comparator");
        Stream.of(fieldLocations).forEach(fieldLocation -> this.fieldComparators.registerComparator((String)fieldLocation, comparator));
    }

    public void registerEqualsForFields(BiPredicate<?, ?> equals, String ... fieldLocations) {
        this.registerComparatorForFields(RecursiveComparisonConfiguration.toComparator(equals), fieldLocations);
    }

    public void strictTypeChecking(boolean strictTypeChecking) {
        this.strictTypeChecking = strictTypeChecking;
    }

    public boolean isInStrictTypeCheckingMode() {
        return this.strictTypeChecking;
    }

    public List<Pattern> getIgnoredFieldsRegexes() {
        return this.ignoredFieldsRegexes;
    }

    public List<Class<?>> getIgnoredOverriddenEqualsForTypes() {
        return this.ignoredOverriddenEqualsForTypes;
    }

    public List<String> getIgnoredOverriddenEqualsForFields() {
        return this.ignoredOverriddenEqualsForFields;
    }

    public List<Pattern> getIgnoredOverriddenEqualsForFieldsMatchingRegexes() {
        return this.ignoredOverriddenEqualsForFieldsMatchingRegexes;
    }

    public Stream<Map.Entry<String, Comparator<?>>> comparatorByFields() {
        return this.fieldComparators.comparatorByFields();
    }

    public String toString() {
        return this.multiLineDescription(ConfigurationProvider.CONFIGURATION_PROVIDER.representation());
    }

    public int hashCode() {
        return java.util.Objects.hash(this.fieldComparators, this.ignoreAllActualEmptyOptionalFields, this.ignoreAllActualNullFields, this.ignoreAllExpectedNullFields, this.ignoreAllOverriddenEquals, this.ignoreCollectionOrder, this.ignoredCollectionOrderInFields, this.ignoredCollectionOrderInFieldsMatchingRegexes, this.ignoredFields, this.ignoredFieldsRegexes, this.ignoredOverriddenEqualsForFields, this.ignoredOverriddenEqualsForTypes, this.ignoredOverriddenEqualsForFieldsMatchingRegexes, this.ignoredTypes, this.strictTypeChecking, this.typeComparators, this.comparedFields);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        RecursiveComparisonConfiguration other = (RecursiveComparisonConfiguration)obj;
        return java.util.Objects.equals(this.fieldComparators, other.fieldComparators) && this.ignoreAllActualEmptyOptionalFields == other.ignoreAllActualEmptyOptionalFields && this.ignoreAllActualNullFields == other.ignoreAllActualNullFields && this.ignoreAllExpectedNullFields == other.ignoreAllExpectedNullFields && this.ignoreAllOverriddenEquals == other.ignoreAllOverriddenEquals && this.ignoreCollectionOrder == other.ignoreCollectionOrder && java.util.Objects.equals(this.ignoredCollectionOrderInFields, other.ignoredCollectionOrderInFields) && java.util.Objects.equals(this.ignoredFields, other.ignoredFields) && java.util.Objects.equals(this.comparedFields, other.comparedFields) && java.util.Objects.equals(this.ignoredFieldsRegexes, other.ignoredFieldsRegexes) && java.util.Objects.equals(this.ignoredOverriddenEqualsForFields, other.ignoredOverriddenEqualsForFields) && java.util.Objects.equals(this.ignoredOverriddenEqualsForTypes, other.ignoredOverriddenEqualsForTypes) && java.util.Objects.equals(this.ignoredOverriddenEqualsForFieldsMatchingRegexes, other.ignoredOverriddenEqualsForFieldsMatchingRegexes) && java.util.Objects.equals(this.ignoredTypes, other.ignoredTypes) && this.strictTypeChecking == other.strictTypeChecking && java.util.Objects.equals(this.typeComparators, other.typeComparators) && java.util.Objects.equals(this.ignoredCollectionOrderInFieldsMatchingRegexes, other.ignoredCollectionOrderInFieldsMatchingRegexes);
    }

    public String multiLineDescription(Representation representation) {
        StringBuilder description = new StringBuilder();
        this.describeIgnoreAllActualNullFields(description);
        this.describeIgnoreAllActualEmptyOptionalFields(description);
        this.describeIgnoreAllExpectedNullFields(description);
        this.describeComparedFields(description);
        this.describeIgnoredFields(description);
        this.describeIgnoredFieldsRegexes(description);
        this.describeIgnoredFieldsForTypes(description);
        this.describeOverriddenEqualsMethodsUsage(description, representation);
        this.describeIgnoreCollectionOrder(description);
        this.describeIgnoredCollectionOrderInFields(description);
        this.describeIgnoredCollectionOrderInFieldsMatchingRegexes(description);
        this.describeRegisteredComparatorByTypes(description);
        this.describeRegisteredComparatorForFields(description);
        this.describeTypeCheckingStrictness(description);
        return description.toString();
    }

    boolean shouldIgnore(DualValue dualValue) {
        FieldLocation fieldLocation = dualValue.fieldLocation;
        return !this.shouldBeCompared(fieldLocation) || this.matchesAnIgnoredField(fieldLocation) || this.matchesAnIgnoredFieldRegex(fieldLocation) || this.shouldIgnoreFieldBasedOnFieldValue(dualValue);
    }

    private boolean shouldBeCompared(FieldLocation fieldLocation) {
        if (this.comparedFields.isEmpty()) {
            return true;
        }
        return this.comparedFields.stream().anyMatch(RecursiveComparisonConfiguration.matchesComparedField(fieldLocation));
    }

    private static Predicate<String> matchesComparedField(FieldLocation field) {
        return fieldToCompare -> field.startsWith((String)fieldToCompare) || fieldToCompare.startsWith(field.getPathToUseInRules());
    }

    Set<String> getNonIgnoredActualFieldNames(DualValue dualValue) {
        Set<String> actualFieldsNames = Objects.getFieldsNames(dualValue.actual.getClass());
        return actualFieldsNames.stream().filter(fieldName -> !this.shouldIgnoreFieldBasedOnFieldLocation(dualValue.fieldLocation.field((String)fieldName))).map(fieldName -> RecursiveComparisonConfiguration.dualValueForField(dualValue, fieldName)).filter(fieldDualValue -> !this.shouldIgnoreFieldBasedOnFieldValue((DualValue)fieldDualValue)).map(DualValue::getFieldName).filter(fieldName -> !fieldName.isEmpty()).collect(Collectors.toSet());
    }

    private boolean shouldIgnoreFieldBasedOnFieldValue(DualValue dualValue) {
        return this.matchesAnIgnoredNullField(dualValue) || this.matchesAnIgnoredFieldType(dualValue) || this.matchesAnIgnoredEmptyOptionalField(dualValue);
    }

    private boolean shouldIgnoreFieldBasedOnFieldLocation(FieldLocation fieldLocation) {
        return this.matchesAnIgnoredField(fieldLocation) || this.matchesAnIgnoredFieldRegex(fieldLocation);
    }

    private static DualValue dualValueForField(DualValue parentDualValue, String fieldName) {
        Object expectedFieldValue;
        Object actualFieldValue = PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, parentDualValue.actual);
        try {
            expectedFieldValue = PropertyOrFieldSupport.COMPARISON.getSimpleValue(fieldName, parentDualValue.expected);
        }
        catch (Exception e) {
            expectedFieldValue = null;
        }
        FieldLocation fieldLocation = parentDualValue.fieldLocation.field(fieldName);
        return new DualValue(fieldLocation, actualFieldValue, expectedFieldValue);
    }

    boolean hasCustomComparator(DualValue dualValue) {
        String fieldName = dualValue.getConcatenatedPath();
        if (this.hasComparatorForField(fieldName)) {
            return true;
        }
        if (dualValue.actual == null && dualValue.expected == null) {
            return false;
        }
        Class<?> valueType = dualValue.actual != null ? dualValue.actual.getClass() : dualValue.expected.getClass();
        return this.hasComparatorForType(valueType);
    }

    boolean shouldIgnoreOverriddenEqualsOf(DualValue dualValue) {
        if (dualValue.isActualJavaType()) {
            return false;
        }
        if (dualValue.isActualAnEnum()) {
            return false;
        }
        return this.ignoreAllOverriddenEquals || this.matchesAnIgnoredOverriddenEqualsField(dualValue.fieldLocation) || dualValue.actual != null && this.shouldIgnoreOverriddenEqualsOf(dualValue.actual.getClass());
    }

    @VisibleForTesting
    boolean shouldIgnoreOverriddenEqualsOf(Class<? extends Object> clazz) {
        return this.matchesAnIgnoredOverriddenEqualsRegex(clazz) || this.matchesAnIgnoredOverriddenEqualsType(clazz);
    }

    boolean shouldIgnoreCollectionOrder(FieldLocation fieldLocation) {
        return this.ignoreCollectionOrder || this.matchesAnIgnoredCollectionOrderInField(fieldLocation) || this.matchesAnIgnoredCollectionOrderInFieldRegex(fieldLocation);
    }

    private void describeIgnoredFieldsRegexes(StringBuilder description) {
        if (!this.ignoredFieldsRegexes.isEmpty()) {
            description.append(String.format("- the fields matching the following regexes were ignored in the comparison: %s%n", this.describeRegexes(this.ignoredFieldsRegexes)));
        }
    }

    private void describeIgnoredFields(StringBuilder description) {
        if (!this.ignoredFields.isEmpty()) {
            description.append(String.format("- the following fields were ignored in the comparison: %s%n", this.describeIgnoredFields()));
        }
    }

    private void describeComparedFields(StringBuilder description) {
        if (!this.comparedFields.isEmpty()) {
            description.append(String.format("- the comparison was performed on the following fields: %s%n", this.describeComparedFields()));
        }
    }

    private void describeIgnoredFieldsForTypes(StringBuilder description) {
        if (!this.ignoredTypes.isEmpty()) {
            description.append(String.format("- the following types were ignored in the comparison: %s%n", this.describeIgnoredTypes()));
        }
    }

    private void describeIgnoreAllActualNullFields(StringBuilder description) {
        if (this.ignoreAllActualNullFields) {
            description.append(String.format("- all actual null fields were ignored in the comparison%n", new Object[0]));
        }
    }

    private void describeIgnoreAllActualEmptyOptionalFields(StringBuilder description) {
        if (this.getIgnoreAllActualEmptyOptionalFields()) {
            description.append(String.format("- all actual empty optional fields were ignored in the comparison (including Optional, OptionalInt, OptionalLong and OptionalDouble)%n", new Object[0]));
        }
    }

    private void describeIgnoreAllExpectedNullFields(StringBuilder description) {
        if (this.ignoreAllExpectedNullFields) {
            description.append(String.format("- all expected null fields were ignored in the comparison%n", new Object[0]));
        }
    }

    private void describeOverriddenEqualsMethodsUsage(StringBuilder description, Representation representation) {
        String header = this.ignoreAllOverriddenEquals ? "- no overridden equals methods were used in the comparison (except for java types)" : "- overridden equals methods were used in the comparison";
        description.append(header);
        if (this.isConfiguredToIgnoreSomeButNotAllOverriddenEqualsMethods()) {
            description.append(String.format(" except for:%n", new Object[0]));
            this.describeIgnoredOverriddenEqualsMethods(description, representation);
        } else {
            description.append(String.format("%n", new Object[0]));
        }
    }

    private void describeIgnoredOverriddenEqualsMethods(StringBuilder description, Representation representation) {
        if (!this.ignoredOverriddenEqualsForFields.isEmpty()) {
            description.append(String.format("%s the following fields: %s%n", INDENT_LEVEL_2, this.describeIgnoredOverriddenEqualsForFields()));
        }
        if (!this.ignoredOverriddenEqualsForTypes.isEmpty()) {
            description.append(String.format("%s the following types: %s%n", INDENT_LEVEL_2, this.describeIgnoredOverriddenEqualsForTypes(representation)));
        }
        if (!this.ignoredOverriddenEqualsForFieldsMatchingRegexes.isEmpty()) {
            description.append(String.format("%s the types matching the following regexes: %s%n", INDENT_LEVEL_2, this.describeRegexes(this.ignoredOverriddenEqualsForFieldsMatchingRegexes)));
        }
    }

    private String describeIgnoredOverriddenEqualsForTypes(Representation representation) {
        List<String> fieldsDescription = this.ignoredOverriddenEqualsForTypes.stream().map(representation::toStringOf).collect(Collectors.toList());
        return RecursiveComparisonConfiguration.join(fieldsDescription);
    }

    private String describeIgnoredOverriddenEqualsForFields() {
        return RecursiveComparisonConfiguration.join(this.ignoredOverriddenEqualsForFields);
    }

    private void describeIgnoreCollectionOrder(StringBuilder description) {
        if (this.ignoreCollectionOrder) {
            description.append(String.format("- collection order was ignored in all fields in the comparison%n", new Object[0]));
        }
    }

    private void describeIgnoredCollectionOrderInFields(StringBuilder description) {
        if (!this.ignoredCollectionOrderInFields.isEmpty()) {
            description.append(String.format("- collection order was ignored in the following fields in the comparison: %s%n", this.describeIgnoredCollectionOrderInFields()));
        }
    }

    private void describeIgnoredCollectionOrderInFieldsMatchingRegexes(StringBuilder description) {
        if (!this.ignoredCollectionOrderInFieldsMatchingRegexes.isEmpty()) {
            description.append(String.format("- collection order was ignored in the fields matching the following regexes in the comparison: %s%n", this.describeRegexes(this.ignoredCollectionOrderInFieldsMatchingRegexes)));
        }
    }

    private boolean matchesAnIgnoredOverriddenEqualsRegex(Class<?> clazz) {
        if (this.ignoredOverriddenEqualsForFieldsMatchingRegexes.isEmpty()) {
            return false;
        }
        String canonicalName = clazz.getCanonicalName();
        return this.ignoredOverriddenEqualsForFieldsMatchingRegexes.stream().anyMatch(regex -> regex.matcher(canonicalName).matches());
    }

    private boolean matchesAnIgnoredOverriddenEqualsType(Class<?> clazz) {
        return this.ignoredOverriddenEqualsForTypes.contains(clazz);
    }

    private boolean matchesAnIgnoredOverriddenEqualsField(FieldLocation fieldLocation) {
        return this.ignoredOverriddenEqualsForFields.stream().anyMatch(fieldLocation::matches);
    }

    private boolean matchesAnIgnoredNullField(DualValue dualValue) {
        return this.ignoreAllActualNullFields && dualValue.actual == null || this.ignoreAllExpectedNullFields && dualValue.expected == null;
    }

    private boolean matchesAnIgnoredEmptyOptionalField(DualValue dualValue) {
        return this.ignoreAllActualEmptyOptionalFields && dualValue.isActualFieldAnEmptyOptionalOfAnyType();
    }

    private boolean matchesAnIgnoredFieldRegex(FieldLocation fieldLocation) {
        return this.ignoredFieldsRegexes.stream().anyMatch(regex -> regex.matcher(fieldLocation.getPathToUseInRules()).matches());
    }

    private boolean matchesAnIgnoredFieldType(DualValue dualValue) {
        Object actual = dualValue.actual;
        if (actual != null) {
            return this.ignoredTypes.contains(actual.getClass());
        }
        Object expected = dualValue.expected;
        if (this.strictTypeChecking && expected != null) {
            return this.ignoredTypes.contains(expected.getClass());
        }
        return false;
    }

    private boolean matchesAnIgnoredField(FieldLocation fieldLocation) {
        return this.ignoredFields.stream().anyMatch(fieldLocation::matches);
    }

    private boolean matchesAnIgnoredCollectionOrderInField(FieldLocation fieldLocation) {
        return this.ignoredCollectionOrderInFields.stream().anyMatch(fieldLocation::matches);
    }

    private boolean matchesAnIgnoredCollectionOrderInFieldRegex(FieldLocation fieldLocation) {
        String pathToUseInRules = fieldLocation.getPathToUseInRules();
        return this.ignoredCollectionOrderInFieldsMatchingRegexes.stream().anyMatch(regex -> regex.matcher(pathToUseInRules).matches());
    }

    private String describeIgnoredFields() {
        return RecursiveComparisonConfiguration.join(this.ignoredFields);
    }

    private String describeComparedFields() {
        return RecursiveComparisonConfiguration.join(this.comparedFields);
    }

    private String describeIgnoredTypes() {
        List<String> typesDescription = this.ignoredTypes.stream().map(Class::getName).collect(Collectors.toList());
        return RecursiveComparisonConfiguration.join(typesDescription);
    }

    private static String join(Collection<String> typesDescription) {
        return Strings.join(typesDescription).with(DEFAULT_DELIMITER);
    }

    private String describeIgnoredCollectionOrderInFields() {
        return RecursiveComparisonConfiguration.join(this.ignoredCollectionOrderInFields);
    }

    private String describeRegexes(List<Pattern> regexes) {
        List<String> fieldsDescription = regexes.stream().map(Pattern::pattern).collect(Collectors.toList());
        return RecursiveComparisonConfiguration.join(fieldsDescription);
    }

    private boolean isConfiguredToIgnoreSomeButNotAllOverriddenEqualsMethods() {
        boolean ignoreSomeOverriddenEqualsMethods = !this.ignoredOverriddenEqualsForFieldsMatchingRegexes.isEmpty() || !this.ignoredOverriddenEqualsForTypes.isEmpty() || !this.ignoredOverriddenEqualsForFields.isEmpty();
        return !this.ignoreAllOverriddenEquals && ignoreSomeOverriddenEqualsMethods;
    }

    private void describeRegisteredComparatorByTypes(StringBuilder description) {
        if (!this.typeComparators.isEmpty()) {
            description.append(String.format("- these types were compared with the following comparators:%n", new Object[0]));
            this.describeComparatorForTypes(description);
        }
    }

    private void describeComparatorForTypes(StringBuilder description) {
        this.typeComparators.comparatorByTypes().map(this::formatRegisteredComparatorByType).forEach(description::append);
    }

    private String formatRegisteredComparatorByType(Map.Entry<Class<?>, Comparator<?>> next) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, next.getKey().getName(), next.getValue());
    }

    private void describeRegisteredComparatorForFields(StringBuilder description) {
        if (!this.fieldComparators.isEmpty()) {
            description.append(String.format("- these fields were compared with the following comparators:%n", new Object[0]));
            this.describeComparatorForFields(description);
            if (!this.typeComparators.isEmpty()) {
                description.append(String.format("- field comparators take precedence over type comparators.%n", new Object[0]));
            }
        }
    }

    private void describeComparatorForFields(StringBuilder description) {
        this.fieldComparators.comparatorByFields().map(this::formatRegisteredComparatorForField).forEach(description::append);
    }

    private String formatRegisteredComparatorForField(Map.Entry<String, Comparator<?>> comparatorForField) {
        return String.format("%s %s -> %s%n", INDENT_LEVEL_2, comparatorForField.getKey(), comparatorForField.getValue());
    }

    private void describeTypeCheckingStrictness(StringBuilder description) {
        String str = this.strictTypeChecking ? "- actual and expected objects and their fields were considered different when of incompatible types (i.e. expected type does not extend actual's type) even if all their fields match, for example a Person instance will never match a PersonDto (call strictTypeChecking(false) to change that behavior).%n" : "- actual and expected objects and their fields were compared field by field recursively even if they were not of the same type, this allows for example to compare a Person to a PersonDto (call strictTypeChecking(true) to change that behavior).%n";
        description.append(String.format(str, new Object[0]));
    }

    public static Builder builder() {
        return new Builder();
    }

    private static Comparator toComparator(BiPredicate equals) {
        java.util.Objects.requireNonNull(equals, "Expecting a non null BiPredicate");
        return (o1, o2) -> equals.test(o1, o2) ? 0 : 1;
    }

    public static final class Builder {
        private boolean strictTypeChecking;
        private boolean ignoreAllActualNullFields;
        private boolean ignoreAllActualEmptyOptionalFields;
        private boolean ignoreAllExpectedNullFields;
        private String[] ignoredFields = new String[0];
        private String[] comparedFields = new String[0];
        private String[] ignoredFieldsMatchingRegexes = new String[0];
        private Class<?>[] ignoredTypes = new Class[0];
        private Class<?>[] ignoredOverriddenEqualsForTypes = new Class[0];
        private String[] ignoredOverriddenEqualsForFields = new String[0];
        private String[] ignoredOverriddenEqualsForFieldsMatchingRegexes = new String[0];
        private boolean ignoreAllOverriddenEquals = true;
        private boolean ignoreCollectionOrder;
        private String[] ignoredCollectionOrderInFields = new String[0];
        private String[] ignoredCollectionOrderInFieldsMatchingRegexes = new String[0];
        private TypeComparators typeComparators = TypeComparators.defaultTypeComparators();
        private FieldComparators fieldComparators = new FieldComparators();

        private Builder() {
        }

        public Builder withStrictTypeChecking(boolean strictTypeChecking) {
            this.strictTypeChecking = strictTypeChecking;
            return this;
        }

        public Builder withIgnoreAllActualNullFields(boolean ignoreAllActualNullFields) {
            this.ignoreAllActualNullFields = ignoreAllActualNullFields;
            return this;
        }

        public Builder withIgnoreAllActualEmptyOptionalFields(boolean ignoreAllActualEmptyOptionalFields) {
            this.ignoreAllActualEmptyOptionalFields = ignoreAllActualEmptyOptionalFields;
            return this;
        }

        public Builder withIgnoreAllExpectedNullFields(boolean ignoreAllExpectedNullFields) {
            this.ignoreAllExpectedNullFields = ignoreAllExpectedNullFields;
            return this;
        }

        public Builder withIgnoredFields(String ... fieldsToIgnore) {
            this.ignoredFields = fieldsToIgnore;
            return this;
        }

        public Builder withComparedFields(String ... fieldsToCompare) {
            this.comparedFields = fieldsToCompare;
            return this;
        }

        public Builder withIgnoredFieldsMatchingRegexes(String ... regexes) {
            this.ignoredFieldsMatchingRegexes = regexes;
            return this;
        }

        public Builder withIgnoredFieldsOfTypes(Class<?> ... types) {
            this.ignoredTypes = types;
            return this;
        }

        public Builder withIgnoredOverriddenEqualsForTypes(Class<?> ... types) {
            this.ignoredOverriddenEqualsForTypes = types;
            return this;
        }

        public Builder withIgnoredOverriddenEqualsForFields(String ... fields) {
            this.ignoredOverriddenEqualsForFields = fields;
            return this;
        }

        public Builder withIgnoredOverriddenEqualsForFieldsMatchingRegexes(String ... regexes) {
            this.ignoredOverriddenEqualsForFieldsMatchingRegexes = regexes;
            return this;
        }

        public Builder withIgnoreAllOverriddenEquals(boolean ignoreAllOverriddenEquals) {
            this.ignoreAllOverriddenEquals = ignoreAllOverriddenEquals;
            return this;
        }

        public Builder withIgnoreCollectionOrder(boolean ignoreCollectionOrder) {
            this.ignoreCollectionOrder = ignoreCollectionOrder;
            return this;
        }

        public Builder withIgnoredCollectionOrderInFields(String ... fieldsToIgnoreCollectionOrder) {
            this.ignoredCollectionOrderInFields = fieldsToIgnoreCollectionOrder;
            return this;
        }

        public Builder withIgnoredCollectionOrderInFieldsMatchingRegexes(String ... regexes) {
            this.ignoredCollectionOrderInFieldsMatchingRegexes = regexes;
            return this;
        }

        public <T> Builder withComparatorForType(Comparator<? super T> comparator, Class<T> type) {
            java.util.Objects.requireNonNull(comparator, "Expecting a non null Comparator");
            this.typeComparators.put(type, comparator);
            return this;
        }

        public <T> Builder withEqualsForType(BiPredicate<? super T, ? super T> equals, Class<T> type) {
            return this.withComparatorForType(RecursiveComparisonConfiguration.toComparator(equals), type);
        }

        public Builder withComparatorForFields(Comparator<?> comparator, String ... fields) {
            java.util.Objects.requireNonNull(comparator, "Expecting a non null Comparator");
            Stream.of(fields).forEach(fieldLocation -> this.fieldComparators.registerComparator((String)fieldLocation, comparator));
            return this;
        }

        public Builder withEqualsForFields(BiPredicate<?, ?> equals, String ... fields) {
            return this.withComparatorForFields(RecursiveComparisonConfiguration.toComparator(equals), fields);
        }

        public RecursiveComparisonConfiguration build() {
            return new RecursiveComparisonConfiguration(this);
        }
    }
}

