/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.error;

import java.util.List;
import org.opentest4j.MultipleFailuresError;

public class AssertJMultipleFailuresError
extends MultipleFailuresError {
    private static final long serialVersionUID = 1L;
    private static final String EOL = System.getProperty("line.separator");
    private static final String ERROR_SEPARATOR = EOL + "-- failure %d --";
    private String heading;

    public AssertJMultipleFailuresError(String heading, List<? extends Throwable> failures) {
        super(heading, failures);
        this.heading = heading;
    }

    @Override
    public String getMessage() {
        List<Throwable> failures = this.getFailures();
        int failureCount = failures.size();
        if (failureCount == 0) {
            return super.getMessage();
        }
        this.heading = AssertJMultipleFailuresError.isBlank(this.heading) ? "Multiple Failures" : this.heading.trim();
        StringBuilder builder = new StringBuilder(EOL).append(this.heading).append(" (").append(failureCount).append(" ").append(AssertJMultipleFailuresError.pluralize(failureCount, "failure", "failures")).append(")");
        for (int i2 = 0; i2 < failureCount; ++i2) {
            builder.append(this.errorSeparator(i2 + 1));
            String message = AssertJMultipleFailuresError.nullSafeMessage(failures.get(i2));
            if (this.hasDescription(message)) {
                builder.append(EOL);
            }
            builder.append(message);
        }
        return builder.toString();
    }

    private String errorSeparator(int errorNumber) {
        return String.format(ERROR_SEPARATOR, errorNumber);
    }

    private boolean hasDescription(String message) {
        return message.startsWith("[");
    }

    private static boolean isBlank(String str) {
        return str == null || str.trim().length() == 0;
    }

    private static String pluralize(int count, String singular, String plural) {
        return count == 1 ? singular : plural;
    }

    private static String nullSafeMessage(Throwable failure) {
        return AssertJMultipleFailuresError.isBlank(failure.getMessage()) ? "<no message> in " + failure.getClass().getName() : failure.getMessage();
    }
}

