/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Optional;
import org.junit.jupiter.api.TestInstance;
import org.junit.jupiter.api.extension.ExtensionContext;
import org.junit.jupiter.api.extension.TestInstances;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.descriptor.AbstractExtensionContext;
import org.junit.jupiter.engine.descriptor.TestMethodTestDescriptor;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.platform.engine.EngineExecutionListener;
import org.junit.platform.engine.support.hierarchical.Node;
import org.junit.platform.engine.support.hierarchical.ThrowableCollector;

final class MethodExtensionContext
extends AbstractExtensionContext<TestMethodTestDescriptor> {
    private final ThrowableCollector throwableCollector;
    private TestInstances testInstances;

    MethodExtensionContext(ExtensionContext parent, EngineExecutionListener engineExecutionListener, TestMethodTestDescriptor testDescriptor, JupiterConfiguration configuration, ExtensionRegistry extensionRegistry, ThrowableCollector throwableCollector) {
        super(parent, engineExecutionListener, testDescriptor, configuration, extensionRegistry);
        this.throwableCollector = throwableCollector;
    }

    @Override
    public Optional<AnnotatedElement> getElement() {
        return Optional.of(((TestMethodTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Class<?>> getTestClass() {
        return Optional.of(((TestMethodTestDescriptor)this.getTestDescriptor()).getTestClass());
    }

    @Override
    public List<Class<?>> getEnclosingTestClasses() {
        return ((TestMethodTestDescriptor)this.getTestDescriptor()).getEnclosingTestClasses();
    }

    @Override
    public Optional<TestInstance.Lifecycle> getTestInstanceLifecycle() {
        return this.getParent().flatMap(ExtensionContext::getTestInstanceLifecycle);
    }

    @Override
    public Optional<Object> getTestInstance() {
        return this.getTestInstances().map(TestInstances::getInnermostInstance);
    }

    @Override
    public Optional<TestInstances> getTestInstances() {
        return Optional.ofNullable(this.testInstances);
    }

    void setTestInstances(TestInstances testInstances) {
        this.testInstances = testInstances;
    }

    @Override
    public Optional<Method> getTestMethod() {
        return Optional.of(((TestMethodTestDescriptor)this.getTestDescriptor()).getTestMethod());
    }

    @Override
    public Optional<Throwable> getExecutionException() {
        return Optional.ofNullable(this.throwableCollector.getThrowable());
    }

    @Override
    protected Node.ExecutionMode getPlatformExecutionMode() {
        return ((TestMethodTestDescriptor)this.getTestDescriptor()).getExecutionMode();
    }
}

