/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.dataformat.csv;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanDescription;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.cfg.MapperBuilder;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.introspect.BeanPropertyDefinition;
import com.fasterxml.jackson.databind.util.NameTransformer;
import com.fasterxml.jackson.databind.util.ViewMatcher;
import com.fasterxml.jackson.dataformat.csv.CsvFactory;
import com.fasterxml.jackson.dataformat.csv.CsvGenerator;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import com.fasterxml.jackson.dataformat.csv.impl.LRUMap;
import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;

public class CsvMapper
extends ObjectMapper {
    private static final long serialVersionUID = 1L;
    protected final LRUMap<ViewKey, CsvSchema> _untypedSchemas;
    protected final LRUMap<ViewKey, CsvSchema> _typedSchemas;

    public CsvMapper() {
        this(new CsvFactory());
    }

    public CsvMapper(CsvFactory f) {
        super(f);
        this.enable(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY);
        this._untypedSchemas = new LRUMap(8, 32);
        this._typedSchemas = new LRUMap(8, 32);
    }

    protected CsvMapper(CsvMapper src) {
        super(src);
        this._untypedSchemas = new LRUMap(8, 32);
        this._typedSchemas = new LRUMap(8, 32);
    }

    public static Builder csvBuilder() {
        return new Builder(new CsvMapper());
    }

    public static Builder builder() {
        return new Builder(new CsvMapper());
    }

    public static Builder builder(CsvFactory streamFactory) {
        return new Builder(new CsvMapper(streamFactory));
    }

    @Override
    public CsvMapper copy() {
        this._checkInvalidCopy(CsvMapper.class);
        return new CsvMapper(this);
    }

    public CsvMapper configure(CsvGenerator.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvMapper configure(CsvParser.Feature f, boolean state) {
        return state ? this.enable(f) : this.disable(f);
    }

    public CsvMapper enable(CsvGenerator.Feature f) {
        ((CsvFactory)this._jsonFactory).enable(f);
        return this;
    }

    public CsvMapper enable(CsvParser.Feature f) {
        ((CsvFactory)this._jsonFactory).enable(f);
        return this;
    }

    public CsvMapper disable(CsvGenerator.Feature f) {
        ((CsvFactory)this._jsonFactory).disable(f);
        return this;
    }

    public CsvMapper disable(CsvParser.Feature f) {
        ((CsvFactory)this._jsonFactory).disable(f);
        return this;
    }

    @Override
    public CsvFactory getFactory() {
        return (CsvFactory)this._jsonFactory;
    }

    public ObjectReader readerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with(this.schemaFor(type));
    }

    public ObjectReader readerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.readerFor(type).with(this.typedSchemaFor(type));
    }

    public ObjectWriter writerWithSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with(this.schemaFor(type));
    }

    public ObjectWriter writerWithTypedSchemaFor(Class<?> pojoType) {
        JavaType type = this.constructType(pojoType);
        if (type.isArrayType() || type.isCollectionLikeType()) {
            throw new IllegalArgumentException("Type can NOT be a Collection or array type");
        }
        return this.writerFor(type).with(this.typedSchemaFor(type));
    }

    public CsvSchema schemaWithHeader() {
        return CsvSchema.emptySchema().withHeader();
    }

    public CsvSchema schema() {
        return CsvSchema.emptySchema();
    }

    public CsvSchema schemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._untypedSchemas, false, null);
    }

    public CsvSchema schemaForWithView(JavaType pojoType, Class<?> view) {
        return this._schemaFor(pojoType, this._untypedSchemas, false, view);
    }

    public final CsvSchema schemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false, null);
    }

    public final CsvSchema schemaForWithView(Class<?> pojoType, Class<?> view) {
        return this._schemaFor(this.constructType(pojoType), this._untypedSchemas, false, view);
    }

    public final CsvSchema schemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false, null);
    }

    public final CsvSchema schemaForWithView(TypeReference<?> pojoTypeRef, Class<?> view) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._untypedSchemas, false, view);
    }

    public CsvSchema typedSchemaFor(JavaType pojoType) {
        return this._schemaFor(pojoType, this._typedSchemas, true, null);
    }

    public CsvSchema typedSchemaForWithView(JavaType pojoType, Class<?> view) {
        return this._schemaFor(pojoType, this._typedSchemas, true, view);
    }

    public final CsvSchema typedSchemaFor(Class<?> pojoType) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true, null);
    }

    public final CsvSchema typedSchemaForWithView(Class<?> pojoType, Class<?> view) {
        return this._schemaFor(this.constructType(pojoType), this._typedSchemas, true, view);
    }

    public final CsvSchema typedSchemaFor(TypeReference<?> pojoTypeRef) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true, null);
    }

    public final CsvSchema typedSchemaForWithView(TypeReference<?> pojoTypeRef, Class<?> view) {
        return this._schemaFor(this.constructType(pojoTypeRef.getType()), this._typedSchemas, true, view);
    }

    protected CsvSchema _schemaFor(JavaType pojoType, LRUMap<ViewKey, CsvSchema> schemas, boolean typed, Class<?> view) {
        ViewKey viewKey = new ViewKey(pojoType, view);
        CsvSchema s2 = (CsvSchema)schemas.get(viewKey);
        if (s2 != null) {
            return s2;
        }
        AnnotationIntrospector intr = this._deserializationConfig.getAnnotationIntrospector();
        CsvSchema.Builder builder = CsvSchema.builder();
        this._addSchemaProperties(builder, intr, typed, pojoType, null, view);
        CsvSchema result = builder.build();
        schemas.put(viewKey, result);
        return result;
    }

    @Deprecated
    protected CsvSchema _schemaFor(JavaType pojoType, LRUMap<ViewKey, CsvSchema> schemas, boolean typed) {
        return this._schemaFor(pojoType, schemas, typed, null);
    }

    protected boolean _nonPojoType(JavaType t2) {
        if (t2.isPrimitive() || t2.isEnumType()) {
            return true;
        }
        Class<?> raw = t2.getRawClass();
        if (Number.class.isAssignableFrom(raw) && (raw == Byte.class || raw == Short.class || raw == Character.class || raw == Integer.class || raw == Long.class || raw == Float.class || raw == Double.class)) {
            return true;
        }
        return raw == Boolean.class || raw == String.class;
    }

    protected void _addSchemaProperties(CsvSchema.Builder builder, AnnotationIntrospector intr, boolean typed, JavaType pojoType, NameTransformer unwrapper, Class<?> view) {
        if (this._nonPojoType(pojoType)) {
            return;
        }
        BeanDescription beanDesc = this.getSerializationConfig().introspect(pojoType);
        boolean includeByDefault = this.isEnabled(MapperFeature.DEFAULT_VIEW_INCLUSION);
        for (BeanPropertyDefinition prop : beanDesc.findProperties()) {
            NameTransformer nextUnwrapper;
            if (view != null) {
                Class<?>[] views = prop.findViews();
                if (views == null) {
                    views = beanDesc.findDefaultViews();
                }
                if ((views != null || !includeByDefault) && !ViewMatcher.construct(views).isVisibleForView(view)) continue;
            }
            if (!prop.couldSerialize()) continue;
            AnnotatedMember m4 = prop.getPrimaryMember();
            if (m4 != null && (nextUnwrapper = intr.findUnwrappingNameTransformer(prop.getPrimaryMember())) != null) {
                if (unwrapper != null) {
                    nextUnwrapper = NameTransformer.chainedTransformer(unwrapper, nextUnwrapper);
                }
                JavaType nextType = m4.getType();
                this._addSchemaProperties(builder, intr, typed, nextType, nextUnwrapper, view);
                continue;
            }
            String name = prop.getName();
            if (unwrapper != null) {
                name = unwrapper.transform(name);
            }
            if (typed && m4 != null) {
                builder.addColumn(name, this._determineType(m4.getRawType()));
                continue;
            }
            builder.addColumn(name);
        }
    }

    protected CsvSchema.ColumnType _determineType(Class<?> propType) {
        if (propType.isArray()) {
            if (propType == byte[].class) {
                return CsvSchema.ColumnType.STRING;
            }
            return CsvSchema.ColumnType.ARRAY;
        }
        if (propType == String.class || propType == Character.TYPE || propType == Character.class) {
            return CsvSchema.ColumnType.STRING;
        }
        if (propType == Boolean.class || propType == Boolean.TYPE) {
            return CsvSchema.ColumnType.BOOLEAN;
        }
        if (propType.isPrimitive()) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Number.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.NUMBER;
        }
        if (Collection.class.isAssignableFrom(propType)) {
            return CsvSchema.ColumnType.ARRAY;
        }
        return CsvSchema.ColumnType.NUMBER_OR_STRING;
    }

    public static final class ViewKey
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final JavaType _pojoType;
        private final Class<?> _view;
        private final int _hashCode;

        public ViewKey(JavaType pojoType, Class<?> view) {
            this._pojoType = pojoType;
            this._view = view;
            this._hashCode = Objects.hash(pojoType, view);
        }

        public int hashCode() {
            return this._hashCode;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null || o.getClass() != this.getClass()) {
                return false;
            }
            ViewKey other = (ViewKey)o;
            if (this._hashCode != other._hashCode || this._view != other._view) {
                return false;
            }
            return Objects.equals(this._pojoType, other._pojoType);
        }

        public String toString() {
            String viewName = this._view != null ? this._view.getName() : null;
            return "[ViewKey: pojoType=" + this._pojoType + ", view=" + viewName + "]";
        }
    }

    public static class Builder
    extends MapperBuilder<CsvMapper, Builder> {
        public Builder(CsvMapper m4) {
            super(m4);
        }

        public Builder enable(CsvParser.Feature ... features) {
            for (CsvParser.Feature f : features) {
                ((CsvMapper)this._mapper).enable(f);
            }
            return this;
        }

        public Builder disable(CsvParser.Feature ... features) {
            for (CsvParser.Feature f : features) {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder configure(CsvParser.Feature f, boolean state) {
            if (state) {
                ((CsvMapper)this._mapper).enable(f);
            } else {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder enable(CsvGenerator.Feature ... features) {
            for (CsvGenerator.Feature f : features) {
                ((CsvMapper)this._mapper).enable(f);
            }
            return this;
        }

        public Builder disable(CsvGenerator.Feature ... features) {
            for (CsvGenerator.Feature f : features) {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }

        public Builder configure(CsvGenerator.Feature f, boolean state) {
            if (state) {
                ((CsvMapper)this._mapper).enable(f);
            } else {
                ((CsvMapper)this._mapper).disable(f);
            }
            return this;
        }
    }
}

