/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.module.blackbird.util;

import com.fasterxml.jackson.module.blackbird.BlackbirdModule;
import com.fasterxml.jackson.module.blackbird.util.Sneaky;
import com.fasterxml.jackson.module.blackbird.util.Unchecked;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ReflectionHack {
    public static MethodHandles.Lookup privateLookupIn(Class<?> lookup, MethodHandles.Lookup orig) throws IllegalAccessException {
        if (Java9Up.FACTORY != null) {
            return Java9Up.privateLookupIn(lookup, orig);
        }
        return Java8.privateLookupIn(lookup);
    }

    static class Java8 {
        private static final Constructor<MethodHandles.Lookup> FACTORY;

        Java8() {
        }

        public static MethodHandles.Lookup privateLookupIn(Class<?> lookup) {
            return Unchecked.function(xva$0 -> (MethodHandles.Lookup)FACTORY.newInstance(xva$0)).apply(lookup);
        }

        static {
            try {
                FACTORY = MethodHandles.Lookup.class.getDeclaredConstructor(Class.class);
            }
            catch (ReflectiveOperationException e) {
                throw new RuntimeException("Unable to use private Lookup constructor", e);
            }
            if (!FACTORY.isAccessible()) {
                FACTORY.setAccessible(true);
            }
        }
    }

    static class Java9Up {
        static final MethodHandle FACTORY = Java9Up.init();

        Java9Up() {
        }

        private static MethodHandle init() {
            try {
                return MethodHandles.lookup().findStatic(MethodHandles.class, "privateLookupIn", MethodType.methodType(MethodHandles.Lookup.class, Class.class, MethodHandles.Lookup.class));
            }
            catch (ReflectiveOperationException e) {
                Logger l = Logger.getLogger(BlackbirdModule.class.getName());
                l.log(Level.WARNING, "Unable to find Java 9+ MethodHandles.privateLookupIn.  Blackbird is not performing optimally!");
                l.log(Level.FINE, "Failure reason for `MethodHandles.privateLookupIn()` not being found: " + e.getMessage(), e);
                return null;
            }
        }

        public static MethodHandles.Lookup privateLookupIn(Class<?> lookup, MethodHandles.Lookup orig) {
            try {
                return FACTORY.invokeExact(lookup, orig);
            }
            catch (ReflectiveOperationException e) {
                return orig;
            }
            catch (Throwable t2) {
                throw Sneaky.throwAnyway(t2);
            }
        }
    }
}

