/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.contract;

import com.fasterxml.jackson.databind.JavaType;
import gov.cms.fiss.pricers.common.application.contract.AnnotationExtractor;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.core.converter.AnnotatedType;
import io.swagger.v3.core.converter.ModelConverter;
import io.swagger.v3.core.converter.ModelConverterContext;
import io.swagger.v3.core.util.Json;
import io.swagger.v3.oas.models.media.Schema;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DigitsAnnotationModelConverter
implements ModelConverter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DigitsAnnotationModelConverter.class);
    private static final List<Class<?>> SUPPORTED_CLASSES = List.of(BigDecimal.class, BigInteger.class, Long.class, Long.TYPE, Integer.class, Integer.TYPE);

    private static boolean isAllowed(JavaType fieldType) {
        Class<?> fieldClass = fieldType.getRawClass();
        LOGGER.debug("Detected class: {}", (Object)fieldClass.getSimpleName());
        if (SUPPORTED_CLASSES.contains(fieldClass)) {
            return true;
        }
        return CharSequence.class.isAssignableFrom(fieldClass);
    }

    @Override
    public Schema<?> resolve(AnnotatedType type, ModelConverterContext context, Iterator<ModelConverter> chain) {
        JavaType fieldType = Json.mapper().constructType(type.getType());
        if (fieldType != null && DigitsAnnotationModelConverter.isAllowed(fieldType)) {
            Pattern patternAnnotation;
            List<Digits> digitAnnotations = AnnotationExtractor.getAnnotation(Digits.class, type.getCtxAnnotations());
            if (digitAnnotations.size() > 1) {
                throw new IllegalStateException("Unable to identify unique annotation instance");
            }
            Digits digitAnnotation = digitAnnotations.isEmpty() ? null : digitAnnotations.get(0);
            List<Pattern> patternAnnotations = AnnotationExtractor.getAnnotation(Pattern.class, type.getCtxAnnotations());
            if (patternAnnotations.size() > 1) {
                throw new IllegalStateException("Unable to identify unique annotation instance");
            }
            Pattern pattern = patternAnnotation = patternAnnotations.isEmpty() ? null : patternAnnotations.get(0);
            if (digitAnnotation != null && patternAnnotation == null) {
                Schema fieldSchema = chain.next().resolve(type, context, chain);
                this.applyAnnotation(fieldSchema, type.getPropertyName(), digitAnnotation);
                LOGGER.debug("Applied pattern '{}' to field '{}'", (Object)fieldSchema.getPattern(), (Object)type.getPropertyName());
                return fieldSchema;
            }
            return chain.next().resolve(type, context, chain);
        }
        return chain.next().resolve(type, context, chain);
    }

    private void applyAnnotation(Schema<?> fieldSchema, String fieldName, Digits digitAnnotation) {
        StringBuilder pattern = new StringBuilder("^");
        BigDecimal fieldMax = ObjectUtils.defaultIfNull(fieldSchema.getMaximum(), BigDecimal.ZERO);
        BigDecimal fieldMin = ObjectUtils.defaultIfNull(fieldSchema.getMinimum(), BigDecimal.ZERO);
        if (BigDecimalUtils.isLessThanZero(fieldMin)) {
            pattern.append("-");
            if (BigDecimalUtils.isGreaterThanOrEqualToZero(fieldMax)) {
                pattern.append("?");
            }
        }
        if (digitAnnotation.integer() > 0) {
            LOGGER.debug("Adding pattern for integral portion of field '{}'", (Object)fieldName);
            pattern.append("\\d{1,");
            pattern.append(digitAnnotation.integer());
            pattern.append("}");
        } else {
            pattern.append(0);
        }
        if (digitAnnotation.fraction() > 0) {
            LOGGER.debug("Adding pattern for fractional portion of field '{}'", (Object)fieldName);
            pattern.append("(");
            pattern.append('\\');
            pattern.append(".[0-9]{1,");
            pattern.append(digitAnnotation.fraction());
            pattern.append("})?");
        }
        pattern.append("$");
        fieldSchema.setPattern(pattern.toString());
        LOGGER.debug("Created pattern '{}' for field '{}'", (Object)fieldSchema.getPattern(), (Object)fieldName);
    }
}

