/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFiveFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;
import lombok.Generated;

@Schema(description="The prospective payment information.", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-DATA-ALL", value="<structure>")})})
public class IrfPaymentData
extends PaymentData {
    @Max(value=99L)
    @Min(value=0L)
    @Schema(description="The average length of stay.", example="17", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-AVG-LOS", value="PIC 9(02)")})})
    private @Max(value=99L) @Min(value=0L) int averageLengthOfStay;
    @BigDecimalScale
    @Schema(description="The budget neutrality conversion amount.", example="15822.36", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-BDGT-NEUT-CONV-AMT", value="PIC 9(05)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal budgetNeutralityConversionAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=4)
    @Schema(description="The case-mix group (CMG) relative weight.", example="0.5925", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-RELATIVE-WGT", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal caseMixGroupRelativeWeight = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
    @BigDecimalScale
    @Schema(description="The charge outlier threshold amount.", example="28779.00", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-CHG-OUTLIER-THRESHOLD", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal chargeOutlierThresholdAmount = BigDecimalUtils.ZERO;
    @Pattern(regexp="Y", message="must be `Y` if present")
    @Schema(description="The cost outlier threshold calculation indicator.", example="Y", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-COT-IND", value="PIC X(01)")})})
    private @Pattern(regexp="Y", message="must be `Y` if present") String costOutlierThresholdIdentifier;
    @BigDecimalScale
    @Schema(description="The facility costs.", example="3596.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FAC-COSTS", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal facilityCosts = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=4)
    @Schema(description="The facility rate percent.", example="0.5699", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FAC-RATE-PCT", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal facilityRatePercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
    @BigDecimalScale
    @Schema(description="The facility-specific payment amount.", example="9388.90", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FAC-SPEC-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal facilitySpecificPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The facility-specific rate pre-blend.", example="12351.80", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FAC-SPEC-RT-PREBLEND", value="PIC 9(05)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal facilitySpecificRatePreBlend = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The federal payment amount.", example="2866.48", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FED-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal federalPaymentAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The federal penalty amount.", example="9968.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FED-PENALTY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal federalPenaltyAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=4)
    @Schema(description="The federal rate percent", example="0.2355", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-FED-RATE-PCT)", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal federalRatePercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The length of stay (LOS).", example="5", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LOS", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int lengthOfStay;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The lifetime reserve (LTR) days used.", example="25", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LTR-DAYS-USED", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int lifetimeReserveDaysUsed;
    @BigDecimalScale
    @Schema(description="The low-income patient (LIP) payment amount.", example="1268.50", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LIP-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal lowIncomePayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The low-income patient (LIP) payment penalty amount.", example="3511.92", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LIP-PENALTY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal lowIncomePaymentPenaltyAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=4)
    @Schema(description="The low-income patient (LIP) adjustment percent.", example="0.0542", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-LIP-PCT", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal lowIncomePaymentPercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
    @BigDecimalScale(scale=5)
    @Schema(description="The national labor percent.", example="0.53226", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-LABOR-PCT", value="PIC 9(01)V9(05)")})})
    @ValidDecimalOutputWithFiveFractionDigits
    private BigDecimal nationalLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.UNNECESSARY);
    @BigDecimalScale(scale=5)
    @Schema(description="The national non-labor percent.", example="0.35232", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-NONLABOR-PCT", value="PIC 9(01)V9(05)")})})
    @ValidDecimalOutputWithFiveFractionDigits
    private BigDecimal nationalNonLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.UNNECESSARY);
    @BigDecimalScale
    @Schema(description="The national threshold adjustment amount.", example="7958.92", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-NAT-THRESHOLD-ADJ", value="PIC 9(05)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal nationalThresholdAdjustmentAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The outlier payment.", example="993.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OUTLIER-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The outlier penalty amount.", example="3625.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OUT-PENALTY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierPenaltyAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The outlier threshold amount.", example="16140.80", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-OUTLIER-THRESHOLD", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal outlierThresholdAmount = BigDecimalUtils.ZERO;
    @Pattern(regexp="[A-D]\\d{4}", message="must be `A`, `B`, `C` or `D` followed by four digits")
    @Schema(description="The priced case-mix group (CMG) code.", example="A5103", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-PRICED-CMG-CODE", value="PIC X(05)")})})
    private @Pattern(regexp="[A-D]\\d{4}", message="must be `A`, `B`, `C` or `D` followed by four digits") String pricedCaseMixGroupCode;
    @Max(value=999L)
    @Min(value=0L)
    @Schema(description="The regular days used.", example="5", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-REG-DAYS-USED", value="PIC 9(03)")})})
    private @Max(value=999L) @Min(value=0L) int regularDaysUsed;
    @BigDecimalScale(scale=4)
    @Schema(description="The rural adjustment percent.", example="0.25590", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-RURAL-ADJUSTMENT", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal ruralAdjustmentPercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
    @BigDecimalScale
    @Schema(description="The standard payment amount.", example="9255.02", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-STANDARD-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal standardPayment = BigDecimalUtils.ZERO;
    @Pattern(regexp="[A-D]\\d{4}", message="must be `A`, `B`, `C` or `D` followed by four digits")
    @Schema(description="The submitted case-mix group (CMG) code.", example="B0701", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-SUBM-CMG-CODE", value="PIC X(05)")})})
    private @Pattern(regexp="[A-D]\\d{4}", message="must be `A`, `B`, `C` or `D` followed by four digits") String submittedCaseMixGroupCode;
    @BigDecimalScale
    @Schema(description="The teaching payment.", example="150.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-TEACH-PAY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal teachingPayment = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The teaching penalty amount.", example="5232.98", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-TEACH-PENALTY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal teachingPaymentPenaltyAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale
    @Schema(description="The total penalty amount.", example="15335.99", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-TOTAL-PENALTY-AMT", value="PIC 9(07)V9(02)")})})
    @ValidDecimalOutputWithTwoFractionDigits
    private BigDecimal totalPenaltyAmount = BigDecimalUtils.ZERO;
    @BigDecimalScale(scale=4)
    @Schema(description="The transfer percent.", example="0.3485", extensions={@Extension(name="cobol-declaration", properties={@ExtensionProperty(name="PPS-TRANSFER-PCT", value="PIC 9(01)V9(04)")})})
    @ValidDecimalOutputWithFourFractionDigits
    private BigDecimal transferPercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);

    @Generated
    public int getAverageLengthOfStay() {
        return this.averageLengthOfStay;
    }

    @Generated
    public BigDecimal getBudgetNeutralityConversionAmount() {
        return this.budgetNeutralityConversionAmount;
    }

    @Generated
    public BigDecimal getCaseMixGroupRelativeWeight() {
        return this.caseMixGroupRelativeWeight;
    }

    @Generated
    public BigDecimal getChargeOutlierThresholdAmount() {
        return this.chargeOutlierThresholdAmount;
    }

    @Generated
    public String getCostOutlierThresholdIdentifier() {
        return this.costOutlierThresholdIdentifier;
    }

    @Generated
    public BigDecimal getFacilityCosts() {
        return this.facilityCosts;
    }

    @Generated
    public BigDecimal getFacilityRatePercent() {
        return this.facilityRatePercent;
    }

    @Generated
    public BigDecimal getFacilitySpecificPayment() {
        return this.facilitySpecificPayment;
    }

    @Generated
    public BigDecimal getFacilitySpecificRatePreBlend() {
        return this.facilitySpecificRatePreBlend;
    }

    @Generated
    public BigDecimal getFederalPaymentAmount() {
        return this.federalPaymentAmount;
    }

    @Generated
    public BigDecimal getFederalPenaltyAmount() {
        return this.federalPenaltyAmount;
    }

    @Generated
    public BigDecimal getFederalRatePercent() {
        return this.federalRatePercent;
    }

    @Generated
    public int getLengthOfStay() {
        return this.lengthOfStay;
    }

    @Generated
    public int getLifetimeReserveDaysUsed() {
        return this.lifetimeReserveDaysUsed;
    }

    @Generated
    public BigDecimal getLowIncomePayment() {
        return this.lowIncomePayment;
    }

    @Generated
    public BigDecimal getLowIncomePaymentPenaltyAmount() {
        return this.lowIncomePaymentPenaltyAmount;
    }

    @Generated
    public BigDecimal getLowIncomePaymentPercent() {
        return this.lowIncomePaymentPercent;
    }

    @Generated
    public BigDecimal getNationalLaborPercent() {
        return this.nationalLaborPercent;
    }

    @Generated
    public BigDecimal getNationalNonLaborPercent() {
        return this.nationalNonLaborPercent;
    }

    @Generated
    public BigDecimal getNationalThresholdAdjustmentAmount() {
        return this.nationalThresholdAdjustmentAmount;
    }

    @Generated
    public BigDecimal getOutlierPayment() {
        return this.outlierPayment;
    }

    @Generated
    public BigDecimal getOutlierPenaltyAmount() {
        return this.outlierPenaltyAmount;
    }

    @Generated
    public BigDecimal getOutlierThresholdAmount() {
        return this.outlierThresholdAmount;
    }

    @Generated
    public String getPricedCaseMixGroupCode() {
        return this.pricedCaseMixGroupCode;
    }

    @Generated
    public int getRegularDaysUsed() {
        return this.regularDaysUsed;
    }

    @Generated
    public BigDecimal getRuralAdjustmentPercent() {
        return this.ruralAdjustmentPercent;
    }

    @Generated
    public BigDecimal getStandardPayment() {
        return this.standardPayment;
    }

    @Generated
    public String getSubmittedCaseMixGroupCode() {
        return this.submittedCaseMixGroupCode;
    }

    @Generated
    public BigDecimal getTeachingPayment() {
        return this.teachingPayment;
    }

    @Generated
    public BigDecimal getTeachingPaymentPenaltyAmount() {
        return this.teachingPaymentPenaltyAmount;
    }

    @Generated
    public BigDecimal getTotalPenaltyAmount() {
        return this.totalPenaltyAmount;
    }

    @Generated
    public BigDecimal getTransferPercent() {
        return this.transferPercent;
    }

    @Generated
    public void setAverageLengthOfStay(int averageLengthOfStay) {
        this.averageLengthOfStay = averageLengthOfStay;
    }

    @Generated
    public void setBudgetNeutralityConversionAmount(BigDecimal budgetNeutralityConversionAmount) {
        this.budgetNeutralityConversionAmount = budgetNeutralityConversionAmount;
    }

    @Generated
    public void setCaseMixGroupRelativeWeight(BigDecimal caseMixGroupRelativeWeight) {
        this.caseMixGroupRelativeWeight = caseMixGroupRelativeWeight;
    }

    @Generated
    public void setChargeOutlierThresholdAmount(BigDecimal chargeOutlierThresholdAmount) {
        this.chargeOutlierThresholdAmount = chargeOutlierThresholdAmount;
    }

    @Generated
    public void setCostOutlierThresholdIdentifier(String costOutlierThresholdIdentifier) {
        this.costOutlierThresholdIdentifier = costOutlierThresholdIdentifier;
    }

    @Generated
    public void setFacilityCosts(BigDecimal facilityCosts) {
        this.facilityCosts = facilityCosts;
    }

    @Generated
    public void setFacilityRatePercent(BigDecimal facilityRatePercent) {
        this.facilityRatePercent = facilityRatePercent;
    }

    @Generated
    public void setFacilitySpecificPayment(BigDecimal facilitySpecificPayment) {
        this.facilitySpecificPayment = facilitySpecificPayment;
    }

    @Generated
    public void setFacilitySpecificRatePreBlend(BigDecimal facilitySpecificRatePreBlend) {
        this.facilitySpecificRatePreBlend = facilitySpecificRatePreBlend;
    }

    @Generated
    public void setFederalPaymentAmount(BigDecimal federalPaymentAmount) {
        this.federalPaymentAmount = federalPaymentAmount;
    }

    @Generated
    public void setFederalPenaltyAmount(BigDecimal federalPenaltyAmount) {
        this.federalPenaltyAmount = federalPenaltyAmount;
    }

    @Generated
    public void setFederalRatePercent(BigDecimal federalRatePercent) {
        this.federalRatePercent = federalRatePercent;
    }

    @Generated
    public void setLengthOfStay(int lengthOfStay) {
        this.lengthOfStay = lengthOfStay;
    }

    @Generated
    public void setLifetimeReserveDaysUsed(int lifetimeReserveDaysUsed) {
        this.lifetimeReserveDaysUsed = lifetimeReserveDaysUsed;
    }

    @Generated
    public void setLowIncomePayment(BigDecimal lowIncomePayment) {
        this.lowIncomePayment = lowIncomePayment;
    }

    @Generated
    public void setLowIncomePaymentPenaltyAmount(BigDecimal lowIncomePaymentPenaltyAmount) {
        this.lowIncomePaymentPenaltyAmount = lowIncomePaymentPenaltyAmount;
    }

    @Generated
    public void setLowIncomePaymentPercent(BigDecimal lowIncomePaymentPercent) {
        this.lowIncomePaymentPercent = lowIncomePaymentPercent;
    }

    @Generated
    public void setNationalLaborPercent(BigDecimal nationalLaborPercent) {
        this.nationalLaborPercent = nationalLaborPercent;
    }

    @Generated
    public void setNationalNonLaborPercent(BigDecimal nationalNonLaborPercent) {
        this.nationalNonLaborPercent = nationalNonLaborPercent;
    }

    @Generated
    public void setNationalThresholdAdjustmentAmount(BigDecimal nationalThresholdAdjustmentAmount) {
        this.nationalThresholdAdjustmentAmount = nationalThresholdAdjustmentAmount;
    }

    @Generated
    public void setOutlierPayment(BigDecimal outlierPayment) {
        this.outlierPayment = outlierPayment;
    }

    @Generated
    public void setOutlierPenaltyAmount(BigDecimal outlierPenaltyAmount) {
        this.outlierPenaltyAmount = outlierPenaltyAmount;
    }

    @Generated
    public void setOutlierThresholdAmount(BigDecimal outlierThresholdAmount) {
        this.outlierThresholdAmount = outlierThresholdAmount;
    }

    @Generated
    public void setPricedCaseMixGroupCode(String pricedCaseMixGroupCode) {
        this.pricedCaseMixGroupCode = pricedCaseMixGroupCode;
    }

    @Generated
    public void setRegularDaysUsed(int regularDaysUsed) {
        this.regularDaysUsed = regularDaysUsed;
    }

    @Generated
    public void setRuralAdjustmentPercent(BigDecimal ruralAdjustmentPercent) {
        this.ruralAdjustmentPercent = ruralAdjustmentPercent;
    }

    @Generated
    public void setStandardPayment(BigDecimal standardPayment) {
        this.standardPayment = standardPayment;
    }

    @Generated
    public void setSubmittedCaseMixGroupCode(String submittedCaseMixGroupCode) {
        this.submittedCaseMixGroupCode = submittedCaseMixGroupCode;
    }

    @Generated
    public void setTeachingPayment(BigDecimal teachingPayment) {
        this.teachingPayment = teachingPayment;
    }

    @Generated
    public void setTeachingPaymentPenaltyAmount(BigDecimal teachingPaymentPenaltyAmount) {
        this.teachingPaymentPenaltyAmount = teachingPaymentPenaltyAmount;
    }

    @Generated
    public void setTotalPenaltyAmount(BigDecimal totalPenaltyAmount) {
        this.totalPenaltyAmount = totalPenaltyAmount;
    }

    @Generated
    public void setTransferPercent(BigDecimal transferPercent) {
        this.transferPercent = transferPercent;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IrfPaymentData)) {
            return false;
        }
        IrfPaymentData other = (IrfPaymentData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getAverageLengthOfStay() != other.getAverageLengthOfStay()) {
            return false;
        }
        if (this.getLengthOfStay() != other.getLengthOfStay()) {
            return false;
        }
        if (this.getLifetimeReserveDaysUsed() != other.getLifetimeReserveDaysUsed()) {
            return false;
        }
        if (this.getRegularDaysUsed() != other.getRegularDaysUsed()) {
            return false;
        }
        BigDecimal this$budgetNeutralityConversionAmount = this.getBudgetNeutralityConversionAmount();
        BigDecimal other$budgetNeutralityConversionAmount = other.getBudgetNeutralityConversionAmount();
        if (this$budgetNeutralityConversionAmount == null ? other$budgetNeutralityConversionAmount != null : !((Object)this$budgetNeutralityConversionAmount).equals(other$budgetNeutralityConversionAmount)) {
            return false;
        }
        BigDecimal this$caseMixGroupRelativeWeight = this.getCaseMixGroupRelativeWeight();
        BigDecimal other$caseMixGroupRelativeWeight = other.getCaseMixGroupRelativeWeight();
        if (this$caseMixGroupRelativeWeight == null ? other$caseMixGroupRelativeWeight != null : !((Object)this$caseMixGroupRelativeWeight).equals(other$caseMixGroupRelativeWeight)) {
            return false;
        }
        BigDecimal this$chargeOutlierThresholdAmount = this.getChargeOutlierThresholdAmount();
        BigDecimal other$chargeOutlierThresholdAmount = other.getChargeOutlierThresholdAmount();
        if (this$chargeOutlierThresholdAmount == null ? other$chargeOutlierThresholdAmount != null : !((Object)this$chargeOutlierThresholdAmount).equals(other$chargeOutlierThresholdAmount)) {
            return false;
        }
        String this$costOutlierThresholdIdentifier = this.getCostOutlierThresholdIdentifier();
        String other$costOutlierThresholdIdentifier = other.getCostOutlierThresholdIdentifier();
        if (this$costOutlierThresholdIdentifier == null ? other$costOutlierThresholdIdentifier != null : !this$costOutlierThresholdIdentifier.equals(other$costOutlierThresholdIdentifier)) {
            return false;
        }
        BigDecimal this$facilityCosts = this.getFacilityCosts();
        BigDecimal other$facilityCosts = other.getFacilityCosts();
        if (this$facilityCosts == null ? other$facilityCosts != null : !((Object)this$facilityCosts).equals(other$facilityCosts)) {
            return false;
        }
        BigDecimal this$facilityRatePercent = this.getFacilityRatePercent();
        BigDecimal other$facilityRatePercent = other.getFacilityRatePercent();
        if (this$facilityRatePercent == null ? other$facilityRatePercent != null : !((Object)this$facilityRatePercent).equals(other$facilityRatePercent)) {
            return false;
        }
        BigDecimal this$facilitySpecificPayment = this.getFacilitySpecificPayment();
        BigDecimal other$facilitySpecificPayment = other.getFacilitySpecificPayment();
        if (this$facilitySpecificPayment == null ? other$facilitySpecificPayment != null : !((Object)this$facilitySpecificPayment).equals(other$facilitySpecificPayment)) {
            return false;
        }
        BigDecimal this$facilitySpecificRatePreBlend = this.getFacilitySpecificRatePreBlend();
        BigDecimal other$facilitySpecificRatePreBlend = other.getFacilitySpecificRatePreBlend();
        if (this$facilitySpecificRatePreBlend == null ? other$facilitySpecificRatePreBlend != null : !((Object)this$facilitySpecificRatePreBlend).equals(other$facilitySpecificRatePreBlend)) {
            return false;
        }
        BigDecimal this$federalPaymentAmount = this.getFederalPaymentAmount();
        BigDecimal other$federalPaymentAmount = other.getFederalPaymentAmount();
        if (this$federalPaymentAmount == null ? other$federalPaymentAmount != null : !((Object)this$federalPaymentAmount).equals(other$federalPaymentAmount)) {
            return false;
        }
        BigDecimal this$federalPenaltyAmount = this.getFederalPenaltyAmount();
        BigDecimal other$federalPenaltyAmount = other.getFederalPenaltyAmount();
        if (this$federalPenaltyAmount == null ? other$federalPenaltyAmount != null : !((Object)this$federalPenaltyAmount).equals(other$federalPenaltyAmount)) {
            return false;
        }
        BigDecimal this$federalRatePercent = this.getFederalRatePercent();
        BigDecimal other$federalRatePercent = other.getFederalRatePercent();
        if (this$federalRatePercent == null ? other$federalRatePercent != null : !((Object)this$federalRatePercent).equals(other$federalRatePercent)) {
            return false;
        }
        BigDecimal this$lowIncomePayment = this.getLowIncomePayment();
        BigDecimal other$lowIncomePayment = other.getLowIncomePayment();
        if (this$lowIncomePayment == null ? other$lowIncomePayment != null : !((Object)this$lowIncomePayment).equals(other$lowIncomePayment)) {
            return false;
        }
        BigDecimal this$lowIncomePaymentPenaltyAmount = this.getLowIncomePaymentPenaltyAmount();
        BigDecimal other$lowIncomePaymentPenaltyAmount = other.getLowIncomePaymentPenaltyAmount();
        if (this$lowIncomePaymentPenaltyAmount == null ? other$lowIncomePaymentPenaltyAmount != null : !((Object)this$lowIncomePaymentPenaltyAmount).equals(other$lowIncomePaymentPenaltyAmount)) {
            return false;
        }
        BigDecimal this$lowIncomePaymentPercent = this.getLowIncomePaymentPercent();
        BigDecimal other$lowIncomePaymentPercent = other.getLowIncomePaymentPercent();
        if (this$lowIncomePaymentPercent == null ? other$lowIncomePaymentPercent != null : !((Object)this$lowIncomePaymentPercent).equals(other$lowIncomePaymentPercent)) {
            return false;
        }
        BigDecimal this$nationalLaborPercent = this.getNationalLaborPercent();
        BigDecimal other$nationalLaborPercent = other.getNationalLaborPercent();
        if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !((Object)this$nationalLaborPercent).equals(other$nationalLaborPercent)) {
            return false;
        }
        BigDecimal this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
        BigDecimal other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
        if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !((Object)this$nationalNonLaborPercent).equals(other$nationalNonLaborPercent)) {
            return false;
        }
        BigDecimal this$nationalThresholdAdjustmentAmount = this.getNationalThresholdAdjustmentAmount();
        BigDecimal other$nationalThresholdAdjustmentAmount = other.getNationalThresholdAdjustmentAmount();
        if (this$nationalThresholdAdjustmentAmount == null ? other$nationalThresholdAdjustmentAmount != null : !((Object)this$nationalThresholdAdjustmentAmount).equals(other$nationalThresholdAdjustmentAmount)) {
            return false;
        }
        BigDecimal this$outlierPayment = this.getOutlierPayment();
        BigDecimal other$outlierPayment = other.getOutlierPayment();
        if (this$outlierPayment == null ? other$outlierPayment != null : !((Object)this$outlierPayment).equals(other$outlierPayment)) {
            return false;
        }
        BigDecimal this$outlierPenaltyAmount = this.getOutlierPenaltyAmount();
        BigDecimal other$outlierPenaltyAmount = other.getOutlierPenaltyAmount();
        if (this$outlierPenaltyAmount == null ? other$outlierPenaltyAmount != null : !((Object)this$outlierPenaltyAmount).equals(other$outlierPenaltyAmount)) {
            return false;
        }
        BigDecimal this$outlierThresholdAmount = this.getOutlierThresholdAmount();
        BigDecimal other$outlierThresholdAmount = other.getOutlierThresholdAmount();
        if (this$outlierThresholdAmount == null ? other$outlierThresholdAmount != null : !((Object)this$outlierThresholdAmount).equals(other$outlierThresholdAmount)) {
            return false;
        }
        String this$pricedCaseMixGroupCode = this.getPricedCaseMixGroupCode();
        String other$pricedCaseMixGroupCode = other.getPricedCaseMixGroupCode();
        if (this$pricedCaseMixGroupCode == null ? other$pricedCaseMixGroupCode != null : !this$pricedCaseMixGroupCode.equals(other$pricedCaseMixGroupCode)) {
            return false;
        }
        BigDecimal this$ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
        BigDecimal other$ruralAdjustmentPercent = other.getRuralAdjustmentPercent();
        if (this$ruralAdjustmentPercent == null ? other$ruralAdjustmentPercent != null : !((Object)this$ruralAdjustmentPercent).equals(other$ruralAdjustmentPercent)) {
            return false;
        }
        BigDecimal this$standardPayment = this.getStandardPayment();
        BigDecimal other$standardPayment = other.getStandardPayment();
        if (this$standardPayment == null ? other$standardPayment != null : !((Object)this$standardPayment).equals(other$standardPayment)) {
            return false;
        }
        String this$submittedCaseMixGroupCode = this.getSubmittedCaseMixGroupCode();
        String other$submittedCaseMixGroupCode = other.getSubmittedCaseMixGroupCode();
        if (this$submittedCaseMixGroupCode == null ? other$submittedCaseMixGroupCode != null : !this$submittedCaseMixGroupCode.equals(other$submittedCaseMixGroupCode)) {
            return false;
        }
        BigDecimal this$teachingPayment = this.getTeachingPayment();
        BigDecimal other$teachingPayment = other.getTeachingPayment();
        if (this$teachingPayment == null ? other$teachingPayment != null : !((Object)this$teachingPayment).equals(other$teachingPayment)) {
            return false;
        }
        BigDecimal this$teachingPaymentPenaltyAmount = this.getTeachingPaymentPenaltyAmount();
        BigDecimal other$teachingPaymentPenaltyAmount = other.getTeachingPaymentPenaltyAmount();
        if (this$teachingPaymentPenaltyAmount == null ? other$teachingPaymentPenaltyAmount != null : !((Object)this$teachingPaymentPenaltyAmount).equals(other$teachingPaymentPenaltyAmount)) {
            return false;
        }
        BigDecimal this$totalPenaltyAmount = this.getTotalPenaltyAmount();
        BigDecimal other$totalPenaltyAmount = other.getTotalPenaltyAmount();
        if (this$totalPenaltyAmount == null ? other$totalPenaltyAmount != null : !((Object)this$totalPenaltyAmount).equals(other$totalPenaltyAmount)) {
            return false;
        }
        BigDecimal this$transferPercent = this.getTransferPercent();
        BigDecimal other$transferPercent = other.getTransferPercent();
        return !(this$transferPercent == null ? other$transferPercent != null : !((Object)this$transferPercent).equals(other$transferPercent));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IrfPaymentData;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getAverageLengthOfStay();
        result = result * 59 + this.getLengthOfStay();
        result = result * 59 + this.getLifetimeReserveDaysUsed();
        result = result * 59 + this.getRegularDaysUsed();
        BigDecimal $budgetNeutralityConversionAmount = this.getBudgetNeutralityConversionAmount();
        result = result * 59 + ($budgetNeutralityConversionAmount == null ? 43 : ((Object)$budgetNeutralityConversionAmount).hashCode());
        BigDecimal $caseMixGroupRelativeWeight = this.getCaseMixGroupRelativeWeight();
        result = result * 59 + ($caseMixGroupRelativeWeight == null ? 43 : ((Object)$caseMixGroupRelativeWeight).hashCode());
        BigDecimal $chargeOutlierThresholdAmount = this.getChargeOutlierThresholdAmount();
        result = result * 59 + ($chargeOutlierThresholdAmount == null ? 43 : ((Object)$chargeOutlierThresholdAmount).hashCode());
        String $costOutlierThresholdIdentifier = this.getCostOutlierThresholdIdentifier();
        result = result * 59 + ($costOutlierThresholdIdentifier == null ? 43 : $costOutlierThresholdIdentifier.hashCode());
        BigDecimal $facilityCosts = this.getFacilityCosts();
        result = result * 59 + ($facilityCosts == null ? 43 : ((Object)$facilityCosts).hashCode());
        BigDecimal $facilityRatePercent = this.getFacilityRatePercent();
        result = result * 59 + ($facilityRatePercent == null ? 43 : ((Object)$facilityRatePercent).hashCode());
        BigDecimal $facilitySpecificPayment = this.getFacilitySpecificPayment();
        result = result * 59 + ($facilitySpecificPayment == null ? 43 : ((Object)$facilitySpecificPayment).hashCode());
        BigDecimal $facilitySpecificRatePreBlend = this.getFacilitySpecificRatePreBlend();
        result = result * 59 + ($facilitySpecificRatePreBlend == null ? 43 : ((Object)$facilitySpecificRatePreBlend).hashCode());
        BigDecimal $federalPaymentAmount = this.getFederalPaymentAmount();
        result = result * 59 + ($federalPaymentAmount == null ? 43 : ((Object)$federalPaymentAmount).hashCode());
        BigDecimal $federalPenaltyAmount = this.getFederalPenaltyAmount();
        result = result * 59 + ($federalPenaltyAmount == null ? 43 : ((Object)$federalPenaltyAmount).hashCode());
        BigDecimal $federalRatePercent = this.getFederalRatePercent();
        result = result * 59 + ($federalRatePercent == null ? 43 : ((Object)$federalRatePercent).hashCode());
        BigDecimal $lowIncomePayment = this.getLowIncomePayment();
        result = result * 59 + ($lowIncomePayment == null ? 43 : ((Object)$lowIncomePayment).hashCode());
        BigDecimal $lowIncomePaymentPenaltyAmount = this.getLowIncomePaymentPenaltyAmount();
        result = result * 59 + ($lowIncomePaymentPenaltyAmount == null ? 43 : ((Object)$lowIncomePaymentPenaltyAmount).hashCode());
        BigDecimal $lowIncomePaymentPercent = this.getLowIncomePaymentPercent();
        result = result * 59 + ($lowIncomePaymentPercent == null ? 43 : ((Object)$lowIncomePaymentPercent).hashCode());
        BigDecimal $nationalLaborPercent = this.getNationalLaborPercent();
        result = result * 59 + ($nationalLaborPercent == null ? 43 : ((Object)$nationalLaborPercent).hashCode());
        BigDecimal $nationalNonLaborPercent = this.getNationalNonLaborPercent();
        result = result * 59 + ($nationalNonLaborPercent == null ? 43 : ((Object)$nationalNonLaborPercent).hashCode());
        BigDecimal $nationalThresholdAdjustmentAmount = this.getNationalThresholdAdjustmentAmount();
        result = result * 59 + ($nationalThresholdAdjustmentAmount == null ? 43 : ((Object)$nationalThresholdAdjustmentAmount).hashCode());
        BigDecimal $outlierPayment = this.getOutlierPayment();
        result = result * 59 + ($outlierPayment == null ? 43 : ((Object)$outlierPayment).hashCode());
        BigDecimal $outlierPenaltyAmount = this.getOutlierPenaltyAmount();
        result = result * 59 + ($outlierPenaltyAmount == null ? 43 : ((Object)$outlierPenaltyAmount).hashCode());
        BigDecimal $outlierThresholdAmount = this.getOutlierThresholdAmount();
        result = result * 59 + ($outlierThresholdAmount == null ? 43 : ((Object)$outlierThresholdAmount).hashCode());
        String $pricedCaseMixGroupCode = this.getPricedCaseMixGroupCode();
        result = result * 59 + ($pricedCaseMixGroupCode == null ? 43 : $pricedCaseMixGroupCode.hashCode());
        BigDecimal $ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
        result = result * 59 + ($ruralAdjustmentPercent == null ? 43 : ((Object)$ruralAdjustmentPercent).hashCode());
        BigDecimal $standardPayment = this.getStandardPayment();
        result = result * 59 + ($standardPayment == null ? 43 : ((Object)$standardPayment).hashCode());
        String $submittedCaseMixGroupCode = this.getSubmittedCaseMixGroupCode();
        result = result * 59 + ($submittedCaseMixGroupCode == null ? 43 : $submittedCaseMixGroupCode.hashCode());
        BigDecimal $teachingPayment = this.getTeachingPayment();
        result = result * 59 + ($teachingPayment == null ? 43 : ((Object)$teachingPayment).hashCode());
        BigDecimal $teachingPaymentPenaltyAmount = this.getTeachingPaymentPenaltyAmount();
        result = result * 59 + ($teachingPaymentPenaltyAmount == null ? 43 : ((Object)$teachingPaymentPenaltyAmount).hashCode());
        BigDecimal $totalPenaltyAmount = this.getTotalPenaltyAmount();
        result = result * 59 + ($totalPenaltyAmount == null ? 43 : ((Object)$totalPenaltyAmount).hashCode());
        BigDecimal $transferPercent = this.getTransferPercent();
        result = result * 59 + ($transferPercent == null ? 43 : ((Object)$transferPercent).hashCode());
        return result;
    }

    @Override
    @Generated
    public String toString() {
        return "IrfPaymentData(averageLengthOfStay=" + this.getAverageLengthOfStay() + ", budgetNeutralityConversionAmount=" + this.getBudgetNeutralityConversionAmount() + ", caseMixGroupRelativeWeight=" + this.getCaseMixGroupRelativeWeight() + ", chargeOutlierThresholdAmount=" + this.getChargeOutlierThresholdAmount() + ", costOutlierThresholdIdentifier=" + this.getCostOutlierThresholdIdentifier() + ", facilityCosts=" + this.getFacilityCosts() + ", facilityRatePercent=" + this.getFacilityRatePercent() + ", facilitySpecificPayment=" + this.getFacilitySpecificPayment() + ", facilitySpecificRatePreBlend=" + this.getFacilitySpecificRatePreBlend() + ", federalPaymentAmount=" + this.getFederalPaymentAmount() + ", federalPenaltyAmount=" + this.getFederalPenaltyAmount() + ", federalRatePercent=" + this.getFederalRatePercent() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDaysUsed=" + this.getLifetimeReserveDaysUsed() + ", lowIncomePayment=" + this.getLowIncomePayment() + ", lowIncomePaymentPenaltyAmount=" + this.getLowIncomePaymentPenaltyAmount() + ", lowIncomePaymentPercent=" + this.getLowIncomePaymentPercent() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", nationalThresholdAdjustmentAmount=" + this.getNationalThresholdAdjustmentAmount() + ", outlierPayment=" + this.getOutlierPayment() + ", outlierPenaltyAmount=" + this.getOutlierPenaltyAmount() + ", outlierThresholdAmount=" + this.getOutlierThresholdAmount() + ", pricedCaseMixGroupCode=" + this.getPricedCaseMixGroupCode() + ", regularDaysUsed=" + this.getRegularDaysUsed() + ", ruralAdjustmentPercent=" + this.getRuralAdjustmentPercent() + ", standardPayment=" + this.getStandardPayment() + ", submittedCaseMixGroupCode=" + this.getSubmittedCaseMixGroupCode() + ", teachingPayment=" + this.getTeachingPayment() + ", teachingPaymentPenaltyAmount=" + this.getTeachingPaymentPenaltyAmount() + ", totalPenaltyAmount=" + this.getTotalPenaltyAmount() + ", transferPercent=" + this.getTransferPercent() + ")";
    }

    @Generated
    public IrfPaymentData() {
    }
}

