/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.irf.core.tables.CmgTableEntry;
import gov.cms.fiss.pricers.irf.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;

public abstract class IrfPricerContext
extends CalculationContext<IrfClaimPricingRequest, IrfClaimPricingResponse> {
    public static final BigDecimal HALF_DAY_LENGTH_OF_STAY = new BigDecimal("0.5");
    public static final int THREE_DAY_LENGTH_OF_STAY = 3;
    public static final int FOURTEEN_DAY_LENGTH_OF_STAY = 14;
    public static final int SIXTEEN_DAY_LENGTH_OF_STAY = 16;
    public static final BigDecimal TWENTY_FIVE_PERCENT = new BigDecimal("0.25");
    public static final BigDecimal EIGHTY_PERCENT = new BigDecimal("0.80");
    public static final String YES_INDICATOR = "Y";
    public static final String CMG_5001 = "5001";
    public static final String CMG_9999 = "9999";
    public static final String CMG_2103 = "2103";
    public static final String CMG_A5001 = "A5001";
    public static final String CMG_A5101 = "A5101";
    public static final String CMG_A5102 = "A5102";
    public static final String CMG_A5103 = "A5103";
    public static final String CMG_A5104 = "A5104";
    public static final BigDecimal FEDERAL_RATE_FULL = BigDecimal.ONE;
    public static final BigDecimal FEDERAL_RATE_TWO_THIRDS = new BigDecimal("0.6667");
    public static final BigDecimal FACILITY_RATE_0 = BigDecimal.ZERO;
    public static final BigDecimal FACILITY_RATE_ONE_THIRD = new BigDecimal("0.3333");
    public static final BigDecimal RURAL_ADJUSTMENT_NONE = BigDecimal.ONE;
    public static final BigDecimal TRANSFER_PERCENT_FULL = BigDecimal.ONE;
    public static final String SPECIAL_PAY_INDICATOR = "1";
    public static final String PROV_WAIVER_STATE = "Y";
    public static final String PROV_BLEND_INDICATOR_3 = "3";
    public static final String PROV_BLEND_INDICATOR_4 = "4";
    public static final String PROV_CBSA_HOSPITAL_QUALITY_INDICATOR_1 = "1";
    private static final int DEFAULT_MAX_LIFETIME_RESERVE_DAYS = 60;
    private static final BigDecimal DEFAULT_NATIONAL_LABOR_PERCENTAGE = new BigDecimal("0.69294");
    private static final BigDecimal DEFAULT_NATIONAL_NON_LABOR_PERCENTAGE = new BigDecimal("0.30706");
    private static final BigDecimal DEFAULT_NATIONAL_THRESHOLD_ADJUSTMENT = new BigDecimal("8848.00");
    private static final BigDecimal DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT = new BigDecimal("15198.00");
    private static final BigDecimal DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT2 = new BigDecimal("14901.00");
    private static final BigDecimal DEFAULT_TRANSITION_RURAL_ADJUSTMENT = BigDecimal.ZERO;
    private static final BigDecimal DEFAULT_RURAL_ADJUSTMENT = new BigDecimal("1.1490");
    private static final BigDecimal DEFAULT_CALC_LOW_INCOME_PERCENTAGE = new BigDecimal("0.3177");
    private static final BigDecimal DEFAULT_CALC_TEACH = new BigDecimal("1.0163");
    private static final Set<String> ORTHOPEDIC_CMG_PREFIXES = new HashSet<String>(Arrays.asList("07", "08", "09"));
    private static final Set<String> URBAN_TO_RURAL_PROVIDERS = new HashSet<String>(Arrays.asList("013027", "08T009", "10T249", "14T011", "193044", "193079", "193096", "19T003", "19T144", "19T304", "28T023", "33T157", "34T015", "34T131", "393047", "39T151", "42T036", "42T067", "49T018", "50T002"));
    private static final String PATIENT_STATUS_EXPIRED = "20";
    private static final Set<String> PATIENT_STATUS_TRANSFERRED = new HashSet<String>(Arrays.asList("02", "03", "61", "62", "63", "64", "82", "83", "89", "90", "91", "92"));
    @JsonIgnore
    protected final DataTables dataTables;
    private CbsaWageIndexEntry cbsaWageIndexEntry;
    private BigDecimal disproportionateShareAdjustment;
    private BigDecimal teachPercent;
    private String ppsBlendIndicator;

    protected IrfPricerContext(IrfClaimPricingRequest input, IrfClaimPricingResponse output, DataTables dataTables) {
        super(input, output);
        this.dataTables = dataTables;
        this.initializeOutput();
    }

    protected void initializeOutput() {
        ((IrfClaimPricingResponse)this.getOutput()).setPaymentData(new IrfPaymentData());
        ((IrfPaymentData)((IrfClaimPricingResponse)this.getOutput()).getPaymentData()).setTotalPayment(BigDecimalUtils.ZERO);
        ((IrfClaimPricingResponse)this.getOutput()).setCalculationVersion(this.getCalculationVersion());
        ((IrfClaimPricingResponse)this.getOutput()).setReturnCodeData(ResultCode.OK_00.toReturnCodeData());
        this.getPaymentData().setTransferPercent(TRANSFER_PERCENT_FULL.setScale(4, RoundingMode.HALF_UP));
    }

    public static boolean isOrthopedicCmg(String cmgCode) {
        return ORTHOPEDIC_CMG_PREFIXES.contains(StringUtils.mid(cmgCode, 1, 2));
    }

    public static Set<String> getUrbanToRuralProviders() {
        return Collections.unmodifiableSet(URBAN_TO_RURAL_PROVIDERS);
    }

    @JsonIgnore
    public IrfClaimData getClaimData() {
        return (IrfClaimData)((IrfClaimPricingRequest)this.getInput()).getClaimData();
    }

    @JsonIgnore
    public InpatientProviderData getProviderData() {
        return (InpatientProviderData)((IrfClaimPricingRequest)this.getInput()).getProviderData();
    }

    @JsonIgnore
    public IrfPaymentData getPaymentData() {
        return (IrfPaymentData)((IrfClaimPricingResponse)this.getOutput()).getPaymentData();
    }

    @JsonIgnore
    public ResultCode getResultCode() {
        return ResultCode.fromCode(Integer.parseInt(((IrfClaimPricingResponse)this.getOutput()).getReturnCodeData().getCode()));
    }

    @JsonIgnore
    public LocalDate getClaimDischargeDate() {
        return this.getClaimData().getDischargeDate();
    }

    public boolean matchesReturnCode(ResultCode expectedCode) {
        return expectedCode.equals((Object)ResultCode.fromCode(this.getResultCode().getCode()));
    }

    public boolean isRuralCbsa(String cbsa) {
        return cbsa.trim().matches("\\d{2}");
    }

    @JsonIgnore
    public LocalDate getProviderEffectiveDate() {
        return this.getProviderData().getEffectiveDate();
    }

    @JsonIgnore
    public LocalDate getProviderFiscalYearBegin() {
        return this.getProviderData().getFiscalYearBeginDate();
    }

    public void applyResultCode(ResultCode resultCode) {
        this.applyResultCode(resultCode, resultCode.getDescription(), resultCode.getExplanation());
    }

    public void applyResultCode(ResultCode resultCode, String description, String explanation) {
        String code = StringUtils.leftPad(String.valueOf(resultCode.getCode()), 2, "0");
        ((IrfClaimPricingResponse)this.getOutput()).getReturnCodeData().setCode(code);
        ((IrfClaimPricingResponse)this.getOutput()).getReturnCodeData().setDescription(description);
        ((IrfClaimPricingResponse)this.getOutput()).getReturnCodeData().setExplanation(explanation);
    }

    public void zeroPaymentRecord() {
        IrfPaymentData zeroRecord = new IrfPaymentData();
        zeroRecord.setTotalPayment(BigDecimalUtils.ZERO);
        ((IrfClaimPricingResponse)this.getOutput()).setPaymentData(zeroRecord);
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate providedEffectiveDate) {
        return this.dataTables.getCbsaWageIndexEntry(cbsa, providedEffectiveDate);
    }

    public CmgTableEntry getCmgEntry(String cmgCode) {
        return this.dataTables.getCmgEntry(cmgCode);
    }

    public BigDecimal getBudgetNeutralConversionAmount() {
        return DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT;
    }

    public BigDecimal getBudgetNeutralConversionAmount2() {
        return DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT2;
    }

    public BigDecimal getCalcLowIncomePercentage() {
        return DEFAULT_CALC_LOW_INCOME_PERCENTAGE;
    }

    public BigDecimal getCalcTeach() {
        return DEFAULT_CALC_TEACH;
    }

    public abstract String getCalculationVersion();

    public abstract LocalDate getFiscalYearEnd();

    public abstract LocalDate getFiscalYearStart();

    public int getMaxLifetimeReserveDays() {
        return 60;
    }

    public BigDecimal getNationalLaborPercentage() {
        return DEFAULT_NATIONAL_LABOR_PERCENTAGE;
    }

    public BigDecimal getNationalNonLaborPercentage() {
        return DEFAULT_NATIONAL_NON_LABOR_PERCENTAGE;
    }

    public BigDecimal getNationalThresholdAdjustment() {
        return DEFAULT_NATIONAL_THRESHOLD_ADJUSTMENT;
    }

    public BigDecimal getTransitionRuralAdjustment() {
        return DEFAULT_TRANSITION_RURAL_ADJUSTMENT;
    }

    public BigDecimal getRuralAdjustment() {
        return DEFAULT_RURAL_ADJUSTMENT;
    }

    public BigDecimal getWageIndexPercentAdjustment() {
        return BigDecimal.ZERO;
    }

    public BigDecimal getWageIndexPercentReductionCap() {
        return BigDecimal.ZERO;
    }

    public boolean hasPenalties() {
        return StringUtils.equalsAny(this.getClaimData().getOutlierSpecialPaymentIndicator(), "2", PROV_BLEND_INDICATOR_3);
    }

    public boolean isNotOutlier() {
        return StringUtils.equalsAny(this.getClaimData().getOutlierSpecialPaymentIndicator(), "1", PROV_BLEND_INDICATOR_3);
    }

    public boolean isPatientExpired() {
        return this.getClaimData().getPatientStatus().equals(PATIENT_STATUS_EXPIRED);
    }

    public boolean isPatientTransferred() {
        return PATIENT_STATUS_TRANSFERRED.contains(this.getClaimData().getPatientStatus());
    }

    public boolean isTransferCase() {
        return PATIENT_STATUS_TRANSFERRED.contains(this.getClaimData().getPatientStatus()) && this.getPaymentData().getLengthOfStay() < this.getPaymentData().getAverageLengthOfStay();
    }

    @Generated
    public CbsaWageIndexEntry getCbsaWageIndexEntry() {
        return this.cbsaWageIndexEntry;
    }

    @Generated
    public void setCbsaWageIndexEntry(CbsaWageIndexEntry cbsaWageIndexEntry) {
        this.cbsaWageIndexEntry = cbsaWageIndexEntry;
    }

    @Generated
    public BigDecimal getDisproportionateShareAdjustment() {
        return this.disproportionateShareAdjustment;
    }

    @Generated
    public void setDisproportionateShareAdjustment(BigDecimal disproportionateShareAdjustment) {
        this.disproportionateShareAdjustment = disproportionateShareAdjustment;
    }

    @Generated
    public BigDecimal getTeachPercent() {
        return this.teachPercent;
    }

    @Generated
    public void setTeachPercent(BigDecimal teachPercent) {
        this.teachPercent = teachPercent;
    }

    @Generated
    public String getPpsBlendIndicator() {
        return this.ppsBlendIndicator;
    }

    @Generated
    public void setPpsBlendIndicator(String ppsBlendIndicator) {
        this.ppsBlendIndicator = ppsBlendIndicator;
    }
}

