/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class DefaultWageIndexRetrieval
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        this.determineWageIndex(calculationContext);
        if (calculationContext.getCbsaWageIndexEntry() == null) {
            calculationContext.applyResultCode(ResultCode.WAGE_INDEX_NOT_FD_60);
            return;
        }
        paymentData.setFinalCbsa(calculationContext.getCbsaWageIndexEntry().getCbsa());
        paymentData.setFinalWageIndex(calculationContext.getCbsaWageIndexEntry().getGeographicWageIndex().setScale(4, RoundingMode.HALF_UP));
    }

    private void determineWageIndex(IrfPricerContext calculationContext) {
        IrfClaimData claimData = calculationContext.getClaimData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        if (StringUtils.equals(providerData.getSpecialPaymentIndicator(), "1")) {
            CbsaWageIndexEntry specialWageIndex = CbsaWageIndexEntry.builder().cbsa(providerData.getCbsaActualGeographicLocation()).geographicWageIndex(providerData.getSpecialWageIndex()).build();
            calculationContext.setCbsaWageIndexEntry(specialWageIndex);
        } else {
            calculationContext.setCbsaWageIndexEntry(calculationContext.getCbsaWageIndexEntry(providerData.getCbsaActualGeographicLocation(), claimData.getDischargeDate()));
        }
    }
}

