/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import java.math.RoundingMode;

public class DetermineRuralAdjustment
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfClaimData claimData = calculationContext.getClaimData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        CbsaWageIndexEntry billingCbsa = calculationContext.getCbsaWageIndexEntry();
        paymentData.setRuralAdjustmentPercent(IrfPricerContext.RURAL_ADJUSTMENT_NONE.setScale(4, RoundingMode.HALF_UP));
        if (IrfPricerContext.getUrbanToRuralProviders().contains(claimData.getProviderCcn())) {
            paymentData.setRuralAdjustmentPercent(calculationContext.getTransitionRuralAdjustment().setScale(4, RoundingMode.HALF_UP));
        } else if (calculationContext.isRuralCbsa(billingCbsa.getCbsa())) {
            paymentData.setRuralAdjustmentPercent(calculationContext.getRuralAdjustment().setScale(4, RoundingMode.HALF_UP));
        } else {
            paymentData.setRuralAdjustmentPercent(IrfPricerContext.RURAL_ADJUSTMENT_NONE.setScale(4, RoundingMode.HALF_UP));
        }
    }
}

