/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.bill_review;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.RoundingMode;

public class InitializeNationalValues
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfClaimData claimData = calculationContext.getClaimData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setSubmittedCaseMixGroupCode(claimData.getCaseMixGroup());
        paymentData.setNationalLaborPercent(calculationContext.getNationalLaborPercentage().setScale(5, RoundingMode.HALF_UP));
        paymentData.setNationalNonLaborPercent(calculationContext.getNationalNonLaborPercentage().setScale(5, RoundingMode.HALF_UP));
        paymentData.setNationalThresholdAdjustmentAmount(calculationContext.getNationalThresholdAdjustment().setScale(2, RoundingMode.HALF_UP));
    }
}

