/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.finalize_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import org.apache.commons.lang3.StringUtils;

public class UpdatePenaltyResultCode
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (calculationContext.hasPenalties()) {
            calculationContext.applyResultCode(calculationContext.getResultCode().adjustForPenalty());
        }
        if (calculationContext.getResultCode().isOutlier() && (paymentData.getLengthOfStay() > paymentData.getRegularDaysUsed() + paymentData.getLifetimeReserveDaysUsed() || StringUtils.equals(paymentData.getCostOutlierThresholdIdentifier(), "Y"))) {
            calculationContext.applyResultCode(ResultCode.OUTLIER_LOS_GT_COVERED_DAYS_67);
        }
    }
}

