/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvContentReader;
import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.common.csv.LookupGenerator;
import gov.cms.fiss.pricers.irf.core.tables.CmgTableEntry;
import java.util.List;
import java.util.Map;

public class CmgTableEntryLookupGenerator {
    private static final String CSV_FILE_PATTERN = "/cmg-codes-%s.csv";
    private final CsvContentReader<CmgTableEntry> contentProvider = new CsvContentReader<CmgTableEntry>(CmgTableEntry.class).customizeSchema(CsvContentReader.HEADER_ROW_CUSTOMIZER);

    public CmgTableEntryLookupGenerator(CsvIngestionConfiguration csvIngestionConfiguration) {
        if (!csvIngestionConfiguration.isValidationEnabled()) {
            this.contentProvider.disableValidation();
        }
    }

    public Map<String, CmgTableEntry> generate(int pricerYear) {
        return this.generate(String.format(CSV_FILE_PATTERN, pricerYear));
    }

    public Map<String, CmgTableEntry> generate(String csvFilename) {
        List<CmgTableEntry> content = this.contentProvider.read(csvFilename);
        return LookupGenerator.generateMap(CmgTableEntry::getCmgCode, content);
    }
}

