/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.errors;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import jakarta.annotation.Priority;
import jakarta.inject.Inject;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.ext.Provider;
import jakarta.ws.rs.ext.WriterInterceptor;
import jakarta.ws.rs.ext.WriterInterceptorContext;
import java.io.IOException;
import org.eclipse.jetty.io.EofException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
@Priority(value=0x7FFFFFFF)
public class EofExceptionWriterInterceptor
implements WriterInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EofExceptionWriterInterceptor.class);
    private final Counter exceptionCounter;

    @Inject
    public EofExceptionWriterInterceptor(MetricRegistry metricRegistry) {
        this.exceptionCounter = metricRegistry.counter(MetricRegistry.name(this.getClass(), "eof-exceptions"));
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (EofException e) {
            LOGGER.debug("Client disconnected while processing and sending response", e);
            this.exceptionCounter.inc();
        }
    }
}

