/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jetty;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.dropwizard.jetty.ZipExceptionHandlingGzipHandler;
import io.dropwizard.util.DataSize;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import java.util.Objects;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.handler.gzip.GzipHandler;
import org.eclipse.jetty.util.compression.DeflaterPool;

public class GzipHandlerFactory {
    private boolean enabled = true;
    @NotNull
    private DataSize minimumEntitySize = DataSize.bytes(256L);
    @NotNull
    private DataSize bufferSize = DataSize.kibibytes(8L);
    private @Nullable Set<String> compressedMimeTypes;
    private @Nullable Set<String> excludedMimeTypes;
    private @Nullable Set<String> includedMethods;
    private @Nullable Set<String> excludedPaths;
    private @Nullable Set<String> includedPaths;
    @Min(value=-1L)
    @Max(value=9L)
    private @Min(value=-1L) @Max(value=9L) int deflateCompressionLevel = -1;
    private boolean syncFlush = false;

    @JsonProperty
    public boolean isEnabled() {
        return this.enabled;
    }

    @JsonProperty
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @JsonProperty
    public DataSize getMinimumEntitySize() {
        return this.minimumEntitySize;
    }

    @JsonProperty
    public void setMinimumEntitySize(DataSize size) {
        this.minimumEntitySize = Objects.requireNonNull(size);
    }

    @JsonProperty
    public DataSize getBufferSize() {
        return this.bufferSize;
    }

    @JsonProperty
    public void setBufferSize(DataSize size) {
        this.bufferSize = Objects.requireNonNull(size);
    }

    @JsonProperty
    public @Nullable Set<String> getCompressedMimeTypes() {
        return this.compressedMimeTypes;
    }

    @JsonProperty
    public void setCompressedMimeTypes(Set<String> mimeTypes) {
        this.compressedMimeTypes = mimeTypes;
    }

    @JsonProperty
    public @Nullable Set<String> getExcludedMimeTypes() {
        return this.excludedMimeTypes;
    }

    @JsonProperty
    public void setExcludedMimeTypes(Set<String> mimeTypes) {
        this.excludedMimeTypes = mimeTypes;
    }

    @JsonProperty
    public int getDeflateCompressionLevel() {
        return this.deflateCompressionLevel;
    }

    @JsonProperty
    public void setDeflateCompressionLevel(int level) {
        this.deflateCompressionLevel = level;
    }

    @JsonProperty
    public @Nullable Set<String> getIncludedMethods() {
        return this.includedMethods;
    }

    @JsonProperty
    public void setIncludedMethods(Set<String> methods) {
        this.includedMethods = methods;
    }

    @JsonProperty
    public @Nullable Set<String> getExcludedPaths() {
        return this.excludedPaths;
    }

    @JsonProperty
    public void setExcludedPaths(Set<String> paths) {
        this.excludedPaths = paths;
    }

    @JsonProperty
    public @Nullable Set<String> getIncludedPaths() {
        return this.includedPaths;
    }

    @JsonProperty
    public void setIncludedPaths(Set<String> paths) {
        this.includedPaths = paths;
    }

    @JsonProperty
    public boolean isSyncFlush() {
        return this.syncFlush;
    }

    @JsonProperty
    public void setSyncFlush(boolean syncFlush) {
        this.syncFlush = syncFlush;
    }

    public GzipHandler build(@Nullable Handler handler) {
        ZipExceptionHandlingGzipHandler gzipHandler = new ZipExceptionHandlingGzipHandler();
        gzipHandler.setHandler(handler);
        gzipHandler.setMinGzipSize((int)this.minimumEntitySize.toBytes());
        gzipHandler.setInflateBufferSize((int)this.bufferSize.toBytes());
        gzipHandler.setDeflaterPool(new DeflaterPool(1024, this.deflateCompressionLevel, true));
        gzipHandler.setSyncFlush(this.syncFlush);
        if (this.compressedMimeTypes != null) {
            gzipHandler.setIncludedMimeTypes(this.compressedMimeTypes.toArray(new String[0]));
        }
        if (this.excludedMimeTypes != null) {
            gzipHandler.setExcludedMimeTypes(this.excludedMimeTypes.toArray(new String[0]));
        }
        if (this.includedMethods != null) {
            gzipHandler.setIncludedMethods(this.includedMethods.toArray(new String[0]));
        }
        if (this.excludedPaths != null) {
            gzipHandler.setExcludedPaths(this.excludedPaths.toArray(new String[0]));
        }
        if (this.includedPaths != null) {
            gzipHandler.setIncludedPaths(this.includedPaths.toArray(new String[0]));
        }
        return gzipHandler;
    }
}

