/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.application.filters;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import com.fasterxml.jackson.databind.ObjectMapper;
import gov.cms.fiss.pricers.common.application.filters.LogFilterConfiguration;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.function.BinaryOperator;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;

public abstract class PricerContentLogFilter {
    public static final String MDC_START_TIME = "startTime";
    public static final String MDC_TRANSACTION_ID = "transactionID";
    public static final String MDC_METHOD = "method";
    public static final String MDC_URI = "uri";
    public static final String MDC_USER_AGENT = "userAgent";
    public static final String MDC_REQUEST_ID = "requestID";
    public static final String MDC_REQUEST_IDENTIFIER = "requestIdentifier";
    public static final String MDC_DCN = "documentControlNumber";
    public static final String MDC_EXECUTION_TIME = "executionTime";
    public static final String MDC_STATUS_CODE = "statusCode";
    public static final String HEADER_DCN = "cms-dcn";
    public static final String HEADER_REQUEST_ID = "cms-pricer-request-id";
    public static final String HEADER_TRANSACTION_ID = "cms-pricer-tx-id";
    protected final ObjectMapper mapper;
    private final LogFilterConfiguration logFilterConfiguration;

    protected PricerContentLogFilter(Logger logger2, ObjectMapper mapper, LogFilterConfiguration logFilterConfiguration) {
        this.mapper = mapper;
        this.logFilterConfiguration = logFilterConfiguration;
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(logger2.getLoggerContext());
        encoder.setPattern("{\"timestamp\":\"%d{yyyy-MM-dd HH:mm:ss:SSSS}\",\"level\":\"%p\",\"mdc\":{" + PricerContentLogFilter.constructMdcJson() + "},\"message\":%m}%n");
        encoder.start();
        ConsoleAppender<ILoggingEvent> appender = new ConsoleAppender<ILoggingEvent>();
        appender.setContext(logger2.getLoggerContext());
        appender.setEncoder(encoder);
        appender.start();
        logger2.detachAndStopAllAppenders();
        logger2.setAdditive(false);
        logger2.addAppender((Appender<ILoggingEvent>)appender);
    }

    private static String constructMdcJson() {
        String[] mdcKeys = new String[]{MDC_START_TIME, MDC_TRANSACTION_ID, MDC_METHOD, MDC_URI, MDC_USER_AGENT, MDC_REQUEST_ID, MDC_REQUEST_IDENTIFIER, MDC_DCN, MDC_EXECUTION_TIME, MDC_STATUS_CODE};
        StringJoiner joiner = new StringJoiner(",");
        for (String key : mdcKeys) {
            joiner.add("\"" + key + "\":\"%X{" + key + "}\"");
        }
        return joiner.toString();
    }

    protected MultivaluedMap<String, String> constrainObjectMap(MultivaluedMap<String, Object> sourceMap) {
        return this.constrainStringMap(sourceMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((List)v.getValue()).stream().map(Object::toString).collect(Collectors.toList()), BinaryOperator.maxBy((a, b) -> 0), MultivaluedHashMap::new)));
    }

    protected MultivaluedMap<String, String> constrainStringMap(MultivaluedMap<String, String> sourceMap) {
        return sourceMap.entrySet().stream().collect(Collectors.toMap(k -> StringUtils.left((String)k.getKey(), this.logFilterConfiguration.getCaptureLength()), v -> ((List)v.getValue()).stream().map(s2 -> StringUtils.left(s2, this.logFilterConfiguration.getCaptureLength())).collect(Collectors.toList()), BinaryOperator.maxBy((a, b) -> 0), MultivaluedHashMap::new));
    }
}

