/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DefaultOutlierCalculation
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfClaimData claimData = calculationContext.getClaimData();
        InpatientProviderData providerData = calculationContext.getProviderData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setFacilityCosts(claimData.getCoveredCharges().multiply(providerData.getOperatingCostToChargeRatio()).setScale(2, RoundingMode.HALF_UP));
        BigDecimal outlierLaborPortion = paymentData.getNationalThresholdAdjustmentAmount().multiply(paymentData.getNationalLaborPercent()).multiply(paymentData.getFinalWageIndex()).setScale(6, RoundingMode.HALF_UP);
        BigDecimal outlierNonLaborPortion = paymentData.getNationalThresholdAdjustmentAmount().multiply(paymentData.getNationalNonLaborPercent()).setScale(6, RoundingMode.HALF_UP);
        BigDecimal fpOutlierThreshold = outlierLaborPortion.add(outlierNonLaborPortion).multiply(paymentData.getRuralAdjustmentPercent()).multiply(paymentData.getLowIncomePaymentPercent().add(calculationContext.getTeachPercent()).add(BigDecimal.ONE)).setScale(6, RoundingMode.HALF_UP);
        BigDecimal outlierThreshold = paymentData.getFederalPaymentAmount().add(fpOutlierThreshold).add(paymentData.getLowIncomePayment()).add(paymentData.getTeachingPayment()).setScale(6, RoundingMode.HALF_UP);
        paymentData.setOutlierThresholdAmount(BigDecimalUtils.truncateDecimals(outlierThreshold));
        if (BigDecimalUtils.isGreaterThan(paymentData.getFacilityCosts(), outlierThreshold)) {
            paymentData.setOutlierPayment(paymentData.getFacilityCosts().subtract(outlierThreshold).multiply(IrfPricerContext.EIGHTY_PERCENT).setScale(2, RoundingMode.HALF_UP));
        }
        BigDecimal chargeOutlierThreshold = outlierThreshold.divide(providerData.getOperatingCostToChargeRatio(), RoundingMode.HALF_UP).setScale(4, RoundingMode.HALF_UP);
        paymentData.setChargeOutlierThresholdAmount(BigDecimalUtils.truncateDecimals(chargeOutlierThreshold));
    }
}

