/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class DefaultResultFinalization
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfClaimPricingResponse output = (IrfClaimPricingResponse)calculationContext.getOutput();
        if (calculationContext.getResultCode().isError()) {
            BigDecimal outlierThreshold = calculationContext.getPaymentData().getChargeOutlierThresholdAmount();
            calculationContext.zeroPaymentRecord();
            if (calculationContext.getResultCode() == ResultCode.OUTLIER_LOS_GT_COVERED_DAYS_67) {
                calculationContext.getPaymentData().setChargeOutlierThresholdAmount(outlierThreshold.setScale(2, RoundingMode.HALF_UP));
            }
        }
        output.setCalculationVersion(calculationContext.getCalculationVersion());
    }
}

