/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.bill_review;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.time.LocalDate;

public class AdjustBlendIndicator
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        LocalDate fiscalYearBeginDate = providerData.getFiscalYearBeginDate();
        calculationContext.setPpsBlendIndicator(providerData.getFederalPpsBlend());
        fiscalYearBeginDate = fiscalYearBeginDate.plusYears(1L).plusMonths(2L);
        if (LocalDateUtils.isAfter(calculationContext.getClaimDischargeDate(), fiscalYearBeginDate)) {
            calculationContext.setPpsBlendIndicator("4");
        }
    }
}

