/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.bill_review;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;

public class CalculateDaysUsed
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfClaimData claimData = calculationContext.getClaimData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (claimData.getLifetimeReserveDays() > claimData.getCoveredDays()) {
            calculationContext.applyResultCode(ResultCode.INVALID_NBR_COVERED_DAYS_62);
            return;
        }
        paymentData.setRegularDaysUsed(claimData.getCoveredDays() - claimData.getLifetimeReserveDays());
        if (paymentData.getRegularDaysUsed() > 0 && paymentData.getRegularDaysUsed() > paymentData.getLengthOfStay()) {
            paymentData.setRegularDaysUsed(paymentData.getLengthOfStay());
        } else if (claimData.getLifetimeReserveDays() > paymentData.getLengthOfStay()) {
            paymentData.setLifetimeReserveDaysUsed(paymentData.getLengthOfStay());
        } else {
            paymentData.setLifetimeReserveDaysUsed(claimData.getLifetimeReserveDays());
        }
    }
}

