/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.bill_review;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.LocalDateUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;

public class ValidateDischargeDate
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        CbsaWageIndexEntry billingCbsa = calculationContext.getCbsaWageIndexEntry();
        if (LocalDateUtils.isBefore(calculationContext.getClaimDischargeDate(), calculationContext.getProviderEffectiveDate()) || LocalDateUtils.isBefore(calculationContext.getClaimDischargeDate(), billingCbsa.getEffectiveDate())) {
            calculationContext.applyResultCode(ResultCode.DISCHRG_DT_LT_EFF_START_DT_55);
        }
    }
}

