/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.finalize_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import java.math.RoundingMode;

public class CalculatePenaltyAmounts
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (calculationContext.hasPenalties()) {
            paymentData.setFederalPenaltyAmount(paymentData.getFederalPaymentAmount().multiply(IrfPricerContext.TWENTY_FIVE_PERCENT).setScale(2, RoundingMode.HALF_UP));
            paymentData.setFederalPaymentAmount(paymentData.getFederalPaymentAmount().subtract(paymentData.getFederalPenaltyAmount()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setLowIncomePaymentPenaltyAmount(paymentData.getLowIncomePayment().multiply(IrfPricerContext.TWENTY_FIVE_PERCENT).setScale(2, RoundingMode.HALF_UP));
            paymentData.setLowIncomePayment(paymentData.getLowIncomePayment().subtract(paymentData.getLowIncomePaymentPenaltyAmount()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setOutlierPenaltyAmount(paymentData.getOutlierPayment().multiply(IrfPricerContext.TWENTY_FIVE_PERCENT).setScale(2, RoundingMode.HALF_UP));
            paymentData.setOutlierPayment(paymentData.getOutlierPayment().subtract(paymentData.getOutlierPenaltyAmount()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setTeachingPaymentPenaltyAmount(paymentData.getTeachingPayment().multiply(IrfPricerContext.TWENTY_FIVE_PERCENT).setScale(2, RoundingMode.HALF_UP));
            paymentData.setTeachingPayment(paymentData.getTeachingPayment().subtract(paymentData.getTeachingPaymentPenaltyAmount()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setTotalPenaltyAmount(paymentData.getFederalPenaltyAmount().add(paymentData.getLowIncomePaymentPenaltyAmount()).add(paymentData.getOutlierPenaltyAmount()).add(paymentData.getTeachingPaymentPenaltyAmount()).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

