/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.jersey.guava;

import com.google.common.base.Optional;
import jakarta.inject.Inject;
import jakarta.inject.Singleton;
import jakarta.ws.rs.ext.ParamConverter;
import jakarta.ws.rs.ext.ParamConverterProvider;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.glassfish.jersey.internal.inject.InjectionManager;
import org.glassfish.jersey.internal.inject.Providers;
import org.glassfish.jersey.internal.util.ReflectionHelper;
import org.glassfish.jersey.internal.util.collection.ClassTypePair;

@Singleton
public class OptionalParamConverterProvider
implements ParamConverterProvider {
    private final InjectionManager manager;

    @Inject
    public OptionalParamConverterProvider(InjectionManager manager) {
        this.manager = manager;
    }

    @Override
    public <T> @Nullable ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Optional.class.equals(rawType)) {
            ClassTypePair ctp;
            List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(genericType);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value) {
                        return rawType.cast(Optional.fromNullable(value));
                    }

                    @Override
                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
            for (ParamConverterProvider provider : Providers.getProviders(this.manager, ParamConverterProvider.class)) {
                final ParamConverter<?> converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                if (converter == null) continue;
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value) {
                        Object convertedValue = value == null ? null : (Object)converter.fromString(value);
                        return rawType.cast(Optional.fromNullable(convertedValue));
                    }

                    @Override
                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
        }
        return null;
    }
}

