/*
 * Decompiled with CFR 0.152.
 */
package io.dropwizard.validation;

import io.dropwizard.util.Duration;
import io.dropwizard.validation.MinDuration;
import jakarta.validation.ConstraintValidator;
import jakarta.validation.ConstraintValidatorContext;
import java.util.concurrent.TimeUnit;

public class MinDurationValidator
implements ConstraintValidator<MinDuration, Duration> {
    private long minQty = 0L;
    private TimeUnit minUnit = TimeUnit.MILLISECONDS;
    private boolean inclusive = true;

    @Override
    public void initialize(MinDuration constraintAnnotation) {
        this.minQty = constraintAnnotation.value();
        this.minUnit = constraintAnnotation.unit();
        this.inclusive = constraintAnnotation.inclusive();
    }

    @Override
    public boolean isValid(Duration value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        long valueNanos = value.toNanoseconds();
        long annotationNanos = this.minUnit.toNanos(this.minQty);
        if (this.inclusive) {
            return valueNanos >= annotationNanos;
        }
        return valueNanos > annotationNanos;
    }
}

