/*
 * Decompiled with CFR 0.152.
 */
package ch.qos.logback.access.common.html;

import ch.qos.logback.access.common.PatternLayout;
import ch.qos.logback.access.common.html.DefaultCssBuilder;
import ch.qos.logback.access.common.spi.IAccessEvent;
import ch.qos.logback.core.CoreConstants;
import ch.qos.logback.core.html.HTMLLayoutBase;
import ch.qos.logback.core.pattern.Converter;
import ch.qos.logback.core.pattern.DynamicConverter;
import java.util.Map;
import java.util.function.Supplier;

public class HTMLLayout
extends HTMLLayoutBase<IAccessEvent> {
    static final String DEFAULT_CONVERSION_PATTERN = "%h%l%u%t%r%s%b";

    public HTMLLayout() {
        this.pattern = DEFAULT_CONVERSION_PATTERN;
        this.cssBuilder = new DefaultCssBuilder();
    }

    protected Map<String, Supplier<DynamicConverter>> getDefaultConverterSupplierMap() {
        return PatternLayout.ACCESS_DEFAULT_CONVERTER_SUPPLIER_MAP;
    }

    @Override
    public String doLayout(IAccessEvent event) {
        StringBuilder buf = new StringBuilder();
        this.startNewTableIfLimitReached(buf);
        boolean odd = true;
        if ((this.counter++ & 1L) == 0L) {
            odd = false;
        }
        buf.append(CoreConstants.LINE_SEPARATOR);
        buf.append("<tr class=\"");
        if (odd) {
            buf.append(" odd\">");
        } else {
            buf.append(" even\">");
        }
        buf.append(CoreConstants.LINE_SEPARATOR);
        for (Converter c = this.head; c != null; c = c.getNext()) {
            this.appendEventToBuffer(buf, c, event);
        }
        buf.append("</tr>");
        buf.append(CoreConstants.LINE_SEPARATOR);
        return buf.toString();
    }

    private void appendEventToBuffer(StringBuilder buf, Converter<IAccessEvent> c, IAccessEvent event) {
        buf.append("<td class=\"");
        buf.append(this.computeConverterName(c));
        buf.append("\">");
        c.write(buf, event);
        buf.append("</td>");
        buf.append(CoreConstants.LINE_SEPARATOR);
    }
}

