/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import java.math.RoundingMode;
import org.apache.commons.lang3.StringUtils;

public class DefaultVariableExtraction
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setFacilitySpecificRatePreBlend(providerData.getPpsFacilitySpecificRate().setScale(2, RoundingMode.HALF_UP));
        if (StringUtils.equals(calculationContext.getPpsBlendIndicator(), "3") && BigDecimalUtils.isZero(paymentData.getFacilitySpecificRatePreBlend())) {
            calculationContext.applyResultCode(ResultCode.PROV_SPEC_RT_0_FOR_BLEND_57);
            return;
        }
        CbsaWageIndexEntry billingCbsa = calculationContext.getCbsaWageIndexEntry();
        if (BigDecimalUtils.isLessThanOrEqualToZero(billingCbsa.getGeographicWageIndex())) {
            calculationContext.applyResultCode(ResultCode.INVALID_WAGE_INDEX_52);
        }
    }
}

