/*
 * Decompiled with CFR 0.152.
 */
package org.assertj.core.api;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.assertj.core.api.AfterAssertionErrorCollected;
import org.assertj.core.api.AssertionErrorCollector;

public class DefaultAssertionErrorCollector
implements AssertionErrorCollector {
    private volatile boolean wasSuccess = true;
    private List<AssertionError> collectedAssertionErrors = Collections.synchronizedList(new ArrayList());
    private AfterAssertionErrorCollected callback = this;
    private AssertionErrorCollector delegate = null;

    @Override
    public void setDelegate(AssertionErrorCollector delegate) {
        this.delegate = delegate;
    }

    @Override
    public Optional<AssertionErrorCollector> getDelegate() {
        return Optional.ofNullable(this.delegate);
    }

    @Override
    public void collectAssertionError(AssertionError error) {
        if (this.delegate == null) {
            this.collectedAssertionErrors.add(error);
            this.wasSuccess = false;
        } else {
            this.delegate.collectAssertionError(error);
        }
        this.callback.onAssertionErrorCollected(error);
    }

    @Override
    public List<AssertionError> assertionErrorsCollected() {
        List<AssertionError> errors = this.delegate != null ? this.delegate.assertionErrorsCollected() : Collections.unmodifiableList(this.collectedAssertionErrors);
        return this.decorateErrorsCollected(errors);
    }

    public void setAfterAssertionErrorCollected(AfterAssertionErrorCollected afterAssertionErrorCollected) {
        this.callback = afterAssertionErrorCollected;
    }

    @Override
    public void succeeded() {
        if (this.delegate == null) {
            this.wasSuccess = true;
        } else {
            this.delegate.succeeded();
        }
    }

    @Override
    public boolean wasSuccess() {
        return this.delegate == null ? this.wasSuccess : this.delegate.wasSuccess();
    }

    protected <T extends Throwable> List<T> decorateErrorsCollected(List<? extends T> errors) {
        return DefaultAssertionErrorCollector.addLineNumberToErrorMessages(errors);
    }

    private static <T extends Throwable> List<T> addLineNumberToErrorMessages(List<? extends T> errors) {
        return errors.stream().map(DefaultAssertionErrorCollector::addLineNumberToErrorMessage).collect(Collectors.toList());
    }

    private static <T extends Throwable> T addLineNumberToErrorMessage(T error) {
        StackTraceElement testStackTraceElement = DefaultAssertionErrorCollector.getFirstStackTraceElementFromTest(error.getStackTrace());
        if (testStackTraceElement != null) {
            try {
                return DefaultAssertionErrorCollector.createNewInstanceWithLineNumberInErrorMessage(error, testStackTraceElement);
            }
            catch (ReflectiveOperationException | SecurityException exception) {
                // empty catch block
            }
        }
        return error;
    }

    private static <T extends Throwable> T createNewInstanceWithLineNumberInErrorMessage(T error, StackTraceElement testStackTraceElement) throws ReflectiveOperationException {
        Constructor<?> constructor = error.getClass().getConstructor(String.class, Throwable.class);
        Throwable errorWithLineNumber = (Throwable)constructor.newInstance(DefaultAssertionErrorCollector.buildErrorMessageWithLineNumber(error.getMessage(), testStackTraceElement), error.getCause());
        errorWithLineNumber.setStackTrace(error.getStackTrace());
        for (Throwable suppressed : error.getSuppressed()) {
            errorWithLineNumber.addSuppressed(suppressed);
        }
        return (T)errorWithLineNumber;
    }

    private static String buildErrorMessageWithLineNumber(String originalErrorMessage, StackTraceElement testStackTraceElement) {
        String testClassName = DefaultAssertionErrorCollector.simpleClassNameOf(testStackTraceElement);
        String testName = testStackTraceElement.getMethodName();
        int lineNumber = testStackTraceElement.getLineNumber();
        return String.format("%s%nat %s.%s(%s.java:%s)", originalErrorMessage, testClassName, testName, testClassName, lineNumber);
    }

    private static String simpleClassNameOf(StackTraceElement testStackTraceElement) {
        String className = testStackTraceElement.getClassName();
        return className.substring(className.lastIndexOf(46) + 1);
    }

    private static StackTraceElement getFirstStackTraceElementFromTest(StackTraceElement[] stacktrace) {
        for (StackTraceElement element : stacktrace) {
            String className = element.getClassName();
            if (DefaultAssertionErrorCollector.isProxiedAssertionClass(className) || className.startsWith("sun.reflect") || className.startsWith("jdk.internal.reflect") || className.startsWith("java.") || className.startsWith("javax.") || className.startsWith("org.junit.") || className.startsWith("org.eclipse.jdt.internal.junit.") || className.startsWith("org.eclipse.jdt.internal.junit4.") || className.startsWith("org.eclipse.jdt.internal.junit5.") || className.startsWith("com.intellij.junit5.") || className.startsWith("com.intellij.rt.execution.junit.") || className.startsWith("com.intellij.rt.junit.") || className.startsWith("org.apache.maven.surefire") || className.startsWith("org.pitest.") || className.startsWith("org.assertj")) continue;
            return element;
        }
        return null;
    }

    private static boolean isProxiedAssertionClass(String className) {
        return className.contains("$ByteBuddy$");
    }
}

