/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.setuid;

import java.io.File;
import java.io.FilenameFilter;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.setuid.Group;
import org.eclipse.jetty.setuid.Passwd;
import org.eclipse.jetty.setuid.RLimit;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;

public class SetUID {
    private static final Logger LOG = Log.getLogger(SetUID.class);
    public static final String __FILENAME = "libsetuid";
    public static final int OK = 0;
    public static final int ERROR = -1;

    public static native int setumask(int var0);

    public static native int setuid(int var0);

    public static native int setgid(int var0);

    public static native int setgroups(int[] var0);

    public static native Passwd getpwnam(String var0) throws SecurityException;

    public static native Passwd getpwuid(int var0) throws SecurityException;

    public static native Group getgrnam(String var0) throws SecurityException;

    public static native Group getgrgid(int var0) throws SecurityException;

    public static native RLimit getrlimitnofiles();

    public static native int setrlimitnofiles(RLimit var0);

    private static void loadLibrary() {
        try {
            if (System.getProperty("jetty.libsetuid.path") != null) {
                LOG.debug("System.loadLibrary(jetty.libsetuid.path)", new Object[0]);
                File lib = new File(System.getProperty("jetty.libsetuid.path"));
                if (lib.exists()) {
                    System.load(lib.getCanonicalPath());
                }
                return;
            }
        }
        catch (Throwable e) {
            LOG.debug(e);
        }
        try {
            LOG.debug("System.loadLibrary(setuid)", new Object[0]);
            System.loadLibrary("setuid");
            return;
        }
        catch (Throwable e) {
            LOG.debug(e);
            try {
                if (System.getProperty("jetty.home") != null) {
                    File lib = SetUID.getLib(new File(System.getProperty("jetty.home"), "lib/setuid/"));
                    if (lib != null && lib.exists()) {
                        LOG.debug("System.load((jetty.home)lib.getCanonicalPath()", new Object[0]);
                        System.load(lib.getCanonicalPath());
                    }
                    return;
                }
            }
            catch (Throwable e2) {
                LOG.debug(e2);
            }
            try {
                if (System.getProperty("jetty.lib") != null) {
                    File lib = SetUID.getLib(new File(System.getProperty("jetty.lib")));
                    LOG.debug("looking for {}", lib.getAbsolutePath());
                    if (lib != null && lib.exists()) {
                        LOG.debug("System.load((jetty.lib)lib.getCanonicalPath())", new Object[0]);
                        System.load(lib.getCanonicalPath());
                    }
                    return;
                }
            }
            catch (Throwable e3) {
                LOG.debug(e3);
            }
            LOG.warn("Error: libsetuid.so could not be found", new Object[0]);
            return;
        }
    }

    private static File getLib(File dir) {
        File[] files = dir.listFiles(new LibFilenameFilter());
        if (files == null || files.length == 0) {
            return null;
        }
        File file = null;
        String osName = SetUID.getOSName();
        for (File f : files) {
            if (f.getName().endsWith(Server.getVersion() + ".so")) {
                file = f;
                break;
            }
            if (!f.getName().endsWith(osName + ".so")) continue;
            LOG.debug("OS specific file found: {}", f.getName());
            file = f;
            break;
        }
        if (file == null) {
            file = files[0];
            LOG.debug("Defaulting to first file: {}", file.getName());
        }
        LOG.debug("setuid library {}", file.getName());
        return file;
    }

    private static File getLib(String dir) {
        return SetUID.getLib(new File(dir));
    }

    private static String getOSName() {
        String os = System.getProperty("os.name");
        if ("Mac OS X".equals(os)) {
            return "osx";
        }
        if ("Linux".equals(os) || "LINUX".equals(os)) {
            return "linux";
        }
        return null;
    }

    static {
        SetUID.loadLibrary();
    }

    private static class LibFilenameFilter
    implements FilenameFilter {
        private LibFilenameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.toLowerCase().contains(SetUID.__FILENAME);
        }
    }
}

