/*
 * Decompiled with CFR 0.152.
 */
package org.junit.platform.commons.util;

import java.net.URL;
import java.security.CodeSource;
import java.util.Optional;
import org.apiguardian.api.API;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.UnrecoverableExceptions;

@API(status=API.Status.INTERNAL, since="1.0")
public final class ClassLoaderUtils {
    private ClassLoaderUtils() {
    }

    public static ClassLoader getClassLoader(Class<?> clazz) {
        Preconditions.notNull(clazz, "Class must not be null");
        ClassLoader classLoader = clazz.getClassLoader();
        return classLoader != null ? classLoader : ClassLoaderUtils.getDefaultClassLoader();
    }

    public static ClassLoader getDefaultClassLoader() {
        try {
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            if (contextClassLoader != null) {
                return contextClassLoader;
            }
        }
        catch (Throwable t2) {
            UnrecoverableExceptions.rethrowIfUnrecoverable(t2);
        }
        return ClassLoader.getSystemClassLoader();
    }

    public static Optional<URL> getLocation(Object object) {
        Preconditions.notNull(object, "object must not be null");
        ClassLoader loader = object.getClass().getClassLoader();
        if (loader == null) {
            for (loader = ClassLoader.getSystemClassLoader(); loader != null && loader.getParent() != null; loader = loader.getParent()) {
            }
        }
        if (loader != null) {
            String name = object.getClass().getName();
            name = name.replace(".", "/") + ".class";
            try {
                return Optional.ofNullable(loader.getResource(name));
            }
            catch (Throwable t2) {
                UnrecoverableExceptions.rethrowIfUnrecoverable(t2);
            }
        }
        try {
            CodeSource codeSource = object.getClass().getProtectionDomain().getCodeSource();
            if (codeSource != null) {
                return Optional.ofNullable(codeSource.getLocation());
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        return Optional.empty();
    }
}

