// Generated by delombok at Fri Aug 15 18:12:03 UTC 2025
package gov.cms.fiss.pricers.irf.api.v2;

import gov.cms.fiss.pricers.common.api.ClaimData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.serialization.StrictLocalDate;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.DecimalMax;
import jakarta.validation.constraints.DecimalMin;
import jakarta.validation.constraints.Digits;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.NotNull;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.time.LocalDate;

@Schema(description = "The claim information associated with the request.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "BILL-NEW-DATA", value = "<structure>")})})
public class IrfClaimData extends ClaimData {
  @NotNull
  @Pattern(regexp = "[A-D]\\d{4}", message = "must be `A`, `B`, `C` or `D` followed by four digits")
  @Schema(description = "The case-mix group (CMG) code.", example = "C2004", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-CMG-CODE", value = "PIC X(05)")})})
  private String caseMixGroup;
  @BigDecimalScale
  @DecimalMax("9999999.99")
  @DecimalMin("0")
  @Digits(integer = 7, fraction = 2)
  @NotNull
  @Schema(description = "The charges covered by the claim.", example = "52332.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-COV-CHARGES", value = "PIC 9(07)V9(02)")})})
  private BigDecimal coveredCharges;
  @Max(999)
  @Min(0)
  @Schema(description = "The covered days.", example = "20", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-COV-DAYS", value = "PIC 9(03)")})})
  private int coveredDays;
  @NotNull
  @Schema(description = "The discharge date of the claim request.", example = "2021-05-13", format = "yyyy-MM-dd", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-DISHCARGE-DATE", value = "B-DISCHG-CC  PIC 9(02)\n" + "B-DISCHG-YY  PIC 9(02)\n" + "B-DISCHG-MM  PIC 9(02)\n" + "B-DISCHG-DD  PIC 9(02)")})})
  @StrictLocalDate
  private LocalDate dischargeDate;
  @Max(999)
  @Min(0)
  @Schema(description = "The length of stay (LOS).", example = "5", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LOS", value = "PIC 9(03)")})})
  private int lengthOfStay;
  @Max(99)
  @Min(0)
  @Schema(description = "The lifetime reserve (LTR) days.", example = "12", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-LTR-DAYS", value = "PIC 9(02)")})})
  private int lifetimeReserveDays;
  @Pattern(regexp = "\\d", message = "must be one digit")
  @Schema(description = "The outlier special payment indicator.", example = "1", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-SPEC-PAY-IND", value = "PIC X(01)")})})
  private String outlierSpecialPaymentIndicator;
  @NotNull
  @Pattern(regexp = "\\d{2}", message = "must be 2 digits")
  @Schema(description = "The patient status.", example = "02", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "B-PATIENT-STATUS", value = "PIC X(02)")})})
  private String patientStatus;

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCaseMixGroup() {
    return this.caseMixGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCoveredCharges() {
    return this.coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getCoveredDays() {
    return this.coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public LocalDate getDischargeDate() {
    return this.dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLifetimeReserveDays() {
    return this.lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getOutlierSpecialPaymentIndicator() {
    return this.outlierSpecialPaymentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPatientStatus() {
    return this.patientStatus;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaseMixGroup(final String caseMixGroup) {
    this.caseMixGroup = caseMixGroup;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredCharges(final BigDecimal coveredCharges) {
    this.coveredCharges = coveredCharges;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCoveredDays(final int coveredDays) {
    this.coveredDays = coveredDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDischargeDate(final LocalDate dischargeDate) {
    this.dischargeDate = dischargeDate;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final int lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDays(final int lifetimeReserveDays) {
    this.lifetimeReserveDays = lifetimeReserveDays;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierSpecialPaymentIndicator(final String outlierSpecialPaymentIndicator) {
    this.outlierSpecialPaymentIndicator = outlierSpecialPaymentIndicator;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPatientStatus(final String patientStatus) {
    this.patientStatus = patientStatus;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IrfClaimData)) return false;
    final IrfClaimData other = (IrfClaimData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getCoveredDays() != other.getCoveredDays()) return false;
    if (this.getLengthOfStay() != other.getLengthOfStay()) return false;
    if (this.getLifetimeReserveDays() != other.getLifetimeReserveDays()) return false;
    final java.lang.Object this$caseMixGroup = this.getCaseMixGroup();
    final java.lang.Object other$caseMixGroup = other.getCaseMixGroup();
    if (this$caseMixGroup == null ? other$caseMixGroup != null : !this$caseMixGroup.equals(other$caseMixGroup)) return false;
    final java.lang.Object this$coveredCharges = this.getCoveredCharges();
    final java.lang.Object other$coveredCharges = other.getCoveredCharges();
    if (this$coveredCharges == null ? other$coveredCharges != null : !this$coveredCharges.equals(other$coveredCharges)) return false;
    final java.lang.Object this$dischargeDate = this.getDischargeDate();
    final java.lang.Object other$dischargeDate = other.getDischargeDate();
    if (this$dischargeDate == null ? other$dischargeDate != null : !this$dischargeDate.equals(other$dischargeDate)) return false;
    final java.lang.Object this$outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
    final java.lang.Object other$outlierSpecialPaymentIndicator = other.getOutlierSpecialPaymentIndicator();
    if (this$outlierSpecialPaymentIndicator == null ? other$outlierSpecialPaymentIndicator != null : !this$outlierSpecialPaymentIndicator.equals(other$outlierSpecialPaymentIndicator)) return false;
    final java.lang.Object this$patientStatus = this.getPatientStatus();
    final java.lang.Object other$patientStatus = other.getPatientStatus();
    if (this$patientStatus == null ? other$patientStatus != null : !this$patientStatus.equals(other$patientStatus)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IrfClaimData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getCoveredDays();
    result = result * PRIME + this.getLengthOfStay();
    result = result * PRIME + this.getLifetimeReserveDays();
    final java.lang.Object $caseMixGroup = this.getCaseMixGroup();
    result = result * PRIME + ($caseMixGroup == null ? 43 : $caseMixGroup.hashCode());
    final java.lang.Object $coveredCharges = this.getCoveredCharges();
    result = result * PRIME + ($coveredCharges == null ? 43 : $coveredCharges.hashCode());
    final java.lang.Object $dischargeDate = this.getDischargeDate();
    result = result * PRIME + ($dischargeDate == null ? 43 : $dischargeDate.hashCode());
    final java.lang.Object $outlierSpecialPaymentIndicator = this.getOutlierSpecialPaymentIndicator();
    result = result * PRIME + ($outlierSpecialPaymentIndicator == null ? 43 : $outlierSpecialPaymentIndicator.hashCode());
    final java.lang.Object $patientStatus = this.getPatientStatus();
    result = result * PRIME + ($patientStatus == null ? 43 : $patientStatus.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IrfClaimData(caseMixGroup=" + this.getCaseMixGroup() + ", coveredCharges=" + this.getCoveredCharges() + ", coveredDays=" + this.getCoveredDays() + ", dischargeDate=" + this.getDischargeDate() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDays=" + this.getLifetimeReserveDays() + ", outlierSpecialPaymentIndicator=" + this.getOutlierSpecialPaymentIndicator() + ", patientStatus=" + this.getPatientStatus() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IrfClaimData() {
  }
}
