// Generated by delombok at Fri Aug 15 18:12:03 UTC 2025
package gov.cms.fiss.pricers.irf.api.v2;

import gov.cms.fiss.pricers.common.api.PaymentData;
import gov.cms.fiss.pricers.common.api.serialization.BigDecimalScale;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFiveFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithFourFractionDigits;
import gov.cms.fiss.pricers.common.api.validation.ValidDecimalOutputWithTwoFractionDigits;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import io.swagger.v3.oas.annotations.extensions.Extension;
import io.swagger.v3.oas.annotations.extensions.ExtensionProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import jakarta.validation.constraints.Max;
import jakarta.validation.constraints.Min;
import jakarta.validation.constraints.Pattern;
import java.math.BigDecimal;
import java.math.RoundingMode;

@Schema(description = "The prospective payment information.", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-DATA-ALL", value = "<structure>")})})
public class IrfPaymentData extends PaymentData {
  @Max(99)
  @Min(0)
  @Schema(description = "The average length of stay.", example = "17", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-AVG-LOS", value = "PIC 9(02)")})})
  private int averageLengthOfStay;
  @BigDecimalScale
  @Schema(description = "The budget neutrality conversion amount.", example = "15822.36", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-BDGT-NEUT-CONV-AMT", value = "PIC 9(05)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal budgetNeutralityConversionAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The case-mix group (CMG) relative weight.", example = "0.5925", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-RELATIVE-WGT", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal caseMixGroupRelativeWeight = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
  @BigDecimalScale
  @Schema(description = "The charge outlier threshold amount.", example = "28779.00", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-CHG-OUTLIER-THRESHOLD", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal chargeOutlierThresholdAmount = BigDecimalUtils.ZERO;
  @Pattern(regexp = "Y", message = "must be `Y` if present")
  @Schema(description = "The cost outlier threshold calculation indicator.", example = "Y", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-COT-IND", value = "PIC X(01)")})})
  private String costOutlierThresholdIdentifier;
  @BigDecimalScale
  @Schema(description = "The facility costs.", example = "3596.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FAC-COSTS", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal facilityCosts = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The facility rate percent.", example = "0.5699", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FAC-RATE-PCT", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal facilityRatePercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
  @BigDecimalScale
  @Schema(description = "The facility-specific payment amount.", example = "9388.90", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FAC-SPEC-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal facilitySpecificPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The facility-specific rate pre-blend.", example = "12351.80", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FAC-SPEC-RT-PREBLEND", value = "PIC 9(05)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal facilitySpecificRatePreBlend = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The federal payment amount.", example = "2866.48", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FED-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal federalPaymentAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The federal penalty amount.", example = "9968.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FED-PENALTY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal federalPenaltyAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The federal rate percent", example = "0.2355", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-FED-RATE-PCT)", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal federalRatePercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
  @Max(999)
  @Min(0)
  @Schema(description = "The length of stay (LOS).", example = "5", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LOS", value = "PIC 9(03)")})})
  private int lengthOfStay;
  @Max(999)
  @Min(0)
  @Schema(description = "The lifetime reserve (LTR) days used.", example = "25", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LTR-DAYS-USED", value = "PIC 9(03)")})})
  private int lifetimeReserveDaysUsed;
  @BigDecimalScale
  @Schema(description = "The low-income patient (LIP) payment amount.", example = "1268.50", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LIP-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal lowIncomePayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The low-income patient (LIP) payment penalty amount.", example = "3511.92", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LIP-PENALTY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal lowIncomePaymentPenaltyAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The low-income patient (LIP) adjustment percent.", example = "0.0542", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-LIP-PCT", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal lowIncomePaymentPercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
  @BigDecimalScale(scale = 5)
  @Schema(description = "The national labor percent.", example = "0.53226", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-LABOR-PCT", value = "PIC 9(01)V9(05)")})})
  @ValidDecimalOutputWithFiveFractionDigits
  private BigDecimal nationalLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.UNNECESSARY);
  @BigDecimalScale(scale = 5)
  @Schema(description = "The national non-labor percent.", example = "0.35232", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-NONLABOR-PCT", value = "PIC 9(01)V9(05)")})})
  @ValidDecimalOutputWithFiveFractionDigits
  private BigDecimal nationalNonLaborPercent = BigDecimal.ZERO.setScale(5, RoundingMode.UNNECESSARY);
  @BigDecimalScale
  @Schema(description = "The national threshold adjustment amount.", example = "7958.92", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-NAT-THRESHOLD-ADJ", value = "PIC 9(05)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal nationalThresholdAdjustmentAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The outlier payment.", example = "993.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OUTLIER-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The outlier penalty amount.", example = "3625.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OUT-PENALTY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierPenaltyAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The outlier threshold amount.", example = "16140.80", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-OUTLIER-THRESHOLD", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal outlierThresholdAmount = BigDecimalUtils.ZERO;
  @Pattern(regexp = "[A-D]\\d{4}", message = "must be `A`, `B`, `C` or `D` followed by four digits")
  @Schema(description = "The priced case-mix group (CMG) code.", example = "A5103", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-PRICED-CMG-CODE", value = "PIC X(05)")})})
  private String pricedCaseMixGroupCode;
  @Max(999)
  @Min(0)
  @Schema(description = "The regular days used.", example = "5", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-REG-DAYS-USED", value = "PIC 9(03)")})})
  private int regularDaysUsed;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The rural adjustment percent.", example = "0.25590", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-RURAL-ADJUSTMENT", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal ruralAdjustmentPercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);
  @BigDecimalScale
  @Schema(description = "The standard payment amount.", example = "9255.02", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-STANDARD-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal standardPayment = BigDecimalUtils.ZERO;
  @Pattern(regexp = "[A-D]\\d{4}", message = "must be `A`, `B`, `C` or `D` followed by four digits")
  @Schema(description = "The submitted case-mix group (CMG) code.", example = "B0701", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-SUBM-CMG-CODE", value = "PIC X(05)")})})
  private String submittedCaseMixGroupCode;
  @BigDecimalScale
  @Schema(description = "The teaching payment.", example = "150.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-TEACH-PAY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal teachingPayment = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The teaching penalty amount.", example = "5232.98", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-TEACH-PENALTY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal teachingPaymentPenaltyAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale
  @Schema(description = "The total penalty amount.", example = "15335.99", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-TOTAL-PENALTY-AMT", value = "PIC 9(07)V9(02)")})})
  @ValidDecimalOutputWithTwoFractionDigits
  private BigDecimal totalPenaltyAmount = BigDecimalUtils.ZERO;
  @BigDecimalScale(scale = 4)
  @Schema(description = "The transfer percent.", example = "0.3485", extensions = {@Extension(name = "cobol-declaration", properties = {@ExtensionProperty(name = "PPS-TRANSFER-PCT", value = "PIC 9(01)V9(04)")})})
  @ValidDecimalOutputWithFourFractionDigits
  private BigDecimal transferPercent = BigDecimal.ZERO.setScale(4, RoundingMode.UNNECESSARY);

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getAverageLengthOfStay() {
    return this.averageLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getBudgetNeutralityConversionAmount() {
    return this.budgetNeutralityConversionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getCaseMixGroupRelativeWeight() {
    return this.caseMixGroupRelativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getChargeOutlierThresholdAmount() {
    return this.chargeOutlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getCostOutlierThresholdIdentifier() {
    return this.costOutlierThresholdIdentifier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilityCosts() {
    return this.facilityCosts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilityRatePercent() {
    return this.facilityRatePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilitySpecificPayment() {
    return this.facilitySpecificPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFacilitySpecificRatePreBlend() {
    return this.facilitySpecificRatePreBlend;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalPaymentAmount() {
    return this.federalPaymentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalPenaltyAmount() {
    return this.federalPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getFederalRatePercent() {
    return this.federalRatePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLengthOfStay() {
    return this.lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getLifetimeReserveDaysUsed() {
    return this.lifetimeReserveDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowIncomePayment() {
    return this.lowIncomePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowIncomePaymentPenaltyAmount() {
    return this.lowIncomePaymentPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getLowIncomePaymentPercent() {
    return this.lowIncomePaymentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalLaborPercent() {
    return this.nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalNonLaborPercent() {
    return this.nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getNationalThresholdAdjustmentAmount() {
    return this.nationalThresholdAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPayment() {
    return this.outlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierPenaltyAmount() {
    return this.outlierPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getOutlierThresholdAmount() {
    return this.outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPricedCaseMixGroupCode() {
    return this.pricedCaseMixGroupCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int getRegularDaysUsed() {
    return this.regularDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getRuralAdjustmentPercent() {
    return this.ruralAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getStandardPayment() {
    return this.standardPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getSubmittedCaseMixGroupCode() {
    return this.submittedCaseMixGroupCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTeachingPayment() {
    return this.teachingPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTeachingPaymentPenaltyAmount() {
    return this.teachingPaymentPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTotalPenaltyAmount() {
    return this.totalPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTransferPercent() {
    return this.transferPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setAverageLengthOfStay(final int averageLengthOfStay) {
    this.averageLengthOfStay = averageLengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setBudgetNeutralityConversionAmount(final BigDecimal budgetNeutralityConversionAmount) {
    this.budgetNeutralityConversionAmount = budgetNeutralityConversionAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCaseMixGroupRelativeWeight(final BigDecimal caseMixGroupRelativeWeight) {
    this.caseMixGroupRelativeWeight = caseMixGroupRelativeWeight;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setChargeOutlierThresholdAmount(final BigDecimal chargeOutlierThresholdAmount) {
    this.chargeOutlierThresholdAmount = chargeOutlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCostOutlierThresholdIdentifier(final String costOutlierThresholdIdentifier) {
    this.costOutlierThresholdIdentifier = costOutlierThresholdIdentifier;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilityCosts(final BigDecimal facilityCosts) {
    this.facilityCosts = facilityCosts;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilityRatePercent(final BigDecimal facilityRatePercent) {
    this.facilityRatePercent = facilityRatePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilitySpecificPayment(final BigDecimal facilitySpecificPayment) {
    this.facilitySpecificPayment = facilitySpecificPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFacilitySpecificRatePreBlend(final BigDecimal facilitySpecificRatePreBlend) {
    this.facilitySpecificRatePreBlend = facilitySpecificRatePreBlend;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPaymentAmount(final BigDecimal federalPaymentAmount) {
    this.federalPaymentAmount = federalPaymentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalPenaltyAmount(final BigDecimal federalPenaltyAmount) {
    this.federalPenaltyAmount = federalPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setFederalRatePercent(final BigDecimal federalRatePercent) {
    this.federalRatePercent = federalRatePercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLengthOfStay(final int lengthOfStay) {
    this.lengthOfStay = lengthOfStay;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLifetimeReserveDaysUsed(final int lifetimeReserveDaysUsed) {
    this.lifetimeReserveDaysUsed = lifetimeReserveDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowIncomePayment(final BigDecimal lowIncomePayment) {
    this.lowIncomePayment = lowIncomePayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowIncomePaymentPenaltyAmount(final BigDecimal lowIncomePaymentPenaltyAmount) {
    this.lowIncomePaymentPenaltyAmount = lowIncomePaymentPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setLowIncomePaymentPercent(final BigDecimal lowIncomePaymentPercent) {
    this.lowIncomePaymentPercent = lowIncomePaymentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalLaborPercent(final BigDecimal nationalLaborPercent) {
    this.nationalLaborPercent = nationalLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalNonLaborPercent(final BigDecimal nationalNonLaborPercent) {
    this.nationalNonLaborPercent = nationalNonLaborPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setNationalThresholdAdjustmentAmount(final BigDecimal nationalThresholdAdjustmentAmount) {
    this.nationalThresholdAdjustmentAmount = nationalThresholdAdjustmentAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPayment(final BigDecimal outlierPayment) {
    this.outlierPayment = outlierPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierPenaltyAmount(final BigDecimal outlierPenaltyAmount) {
    this.outlierPenaltyAmount = outlierPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setOutlierThresholdAmount(final BigDecimal outlierThresholdAmount) {
    this.outlierThresholdAmount = outlierThresholdAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPricedCaseMixGroupCode(final String pricedCaseMixGroupCode) {
    this.pricedCaseMixGroupCode = pricedCaseMixGroupCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRegularDaysUsed(final int regularDaysUsed) {
    this.regularDaysUsed = regularDaysUsed;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setRuralAdjustmentPercent(final BigDecimal ruralAdjustmentPercent) {
    this.ruralAdjustmentPercent = ruralAdjustmentPercent;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setStandardPayment(final BigDecimal standardPayment) {
    this.standardPayment = standardPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setSubmittedCaseMixGroupCode(final String submittedCaseMixGroupCode) {
    this.submittedCaseMixGroupCode = submittedCaseMixGroupCode;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTeachingPayment(final BigDecimal teachingPayment) {
    this.teachingPayment = teachingPayment;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTeachingPaymentPenaltyAmount(final BigDecimal teachingPaymentPenaltyAmount) {
    this.teachingPaymentPenaltyAmount = teachingPaymentPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTotalPenaltyAmount(final BigDecimal totalPenaltyAmount) {
    this.totalPenaltyAmount = totalPenaltyAmount;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTransferPercent(final BigDecimal transferPercent) {
    this.transferPercent = transferPercent;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public boolean equals(final java.lang.Object o) {
    if (o == this) return true;
    if (!(o instanceof IrfPaymentData)) return false;
    final IrfPaymentData other = (IrfPaymentData) o;
    if (!other.canEqual((java.lang.Object) this)) return false;
    if (!super.equals(o)) return false;
    if (this.getAverageLengthOfStay() != other.getAverageLengthOfStay()) return false;
    if (this.getLengthOfStay() != other.getLengthOfStay()) return false;
    if (this.getLifetimeReserveDaysUsed() != other.getLifetimeReserveDaysUsed()) return false;
    if (this.getRegularDaysUsed() != other.getRegularDaysUsed()) return false;
    final java.lang.Object this$budgetNeutralityConversionAmount = this.getBudgetNeutralityConversionAmount();
    final java.lang.Object other$budgetNeutralityConversionAmount = other.getBudgetNeutralityConversionAmount();
    if (this$budgetNeutralityConversionAmount == null ? other$budgetNeutralityConversionAmount != null : !this$budgetNeutralityConversionAmount.equals(other$budgetNeutralityConversionAmount)) return false;
    final java.lang.Object this$caseMixGroupRelativeWeight = this.getCaseMixGroupRelativeWeight();
    final java.lang.Object other$caseMixGroupRelativeWeight = other.getCaseMixGroupRelativeWeight();
    if (this$caseMixGroupRelativeWeight == null ? other$caseMixGroupRelativeWeight != null : !this$caseMixGroupRelativeWeight.equals(other$caseMixGroupRelativeWeight)) return false;
    final java.lang.Object this$chargeOutlierThresholdAmount = this.getChargeOutlierThresholdAmount();
    final java.lang.Object other$chargeOutlierThresholdAmount = other.getChargeOutlierThresholdAmount();
    if (this$chargeOutlierThresholdAmount == null ? other$chargeOutlierThresholdAmount != null : !this$chargeOutlierThresholdAmount.equals(other$chargeOutlierThresholdAmount)) return false;
    final java.lang.Object this$costOutlierThresholdIdentifier = this.getCostOutlierThresholdIdentifier();
    final java.lang.Object other$costOutlierThresholdIdentifier = other.getCostOutlierThresholdIdentifier();
    if (this$costOutlierThresholdIdentifier == null ? other$costOutlierThresholdIdentifier != null : !this$costOutlierThresholdIdentifier.equals(other$costOutlierThresholdIdentifier)) return false;
    final java.lang.Object this$facilityCosts = this.getFacilityCosts();
    final java.lang.Object other$facilityCosts = other.getFacilityCosts();
    if (this$facilityCosts == null ? other$facilityCosts != null : !this$facilityCosts.equals(other$facilityCosts)) return false;
    final java.lang.Object this$facilityRatePercent = this.getFacilityRatePercent();
    final java.lang.Object other$facilityRatePercent = other.getFacilityRatePercent();
    if (this$facilityRatePercent == null ? other$facilityRatePercent != null : !this$facilityRatePercent.equals(other$facilityRatePercent)) return false;
    final java.lang.Object this$facilitySpecificPayment = this.getFacilitySpecificPayment();
    final java.lang.Object other$facilitySpecificPayment = other.getFacilitySpecificPayment();
    if (this$facilitySpecificPayment == null ? other$facilitySpecificPayment != null : !this$facilitySpecificPayment.equals(other$facilitySpecificPayment)) return false;
    final java.lang.Object this$facilitySpecificRatePreBlend = this.getFacilitySpecificRatePreBlend();
    final java.lang.Object other$facilitySpecificRatePreBlend = other.getFacilitySpecificRatePreBlend();
    if (this$facilitySpecificRatePreBlend == null ? other$facilitySpecificRatePreBlend != null : !this$facilitySpecificRatePreBlend.equals(other$facilitySpecificRatePreBlend)) return false;
    final java.lang.Object this$federalPaymentAmount = this.getFederalPaymentAmount();
    final java.lang.Object other$federalPaymentAmount = other.getFederalPaymentAmount();
    if (this$federalPaymentAmount == null ? other$federalPaymentAmount != null : !this$federalPaymentAmount.equals(other$federalPaymentAmount)) return false;
    final java.lang.Object this$federalPenaltyAmount = this.getFederalPenaltyAmount();
    final java.lang.Object other$federalPenaltyAmount = other.getFederalPenaltyAmount();
    if (this$federalPenaltyAmount == null ? other$federalPenaltyAmount != null : !this$federalPenaltyAmount.equals(other$federalPenaltyAmount)) return false;
    final java.lang.Object this$federalRatePercent = this.getFederalRatePercent();
    final java.lang.Object other$federalRatePercent = other.getFederalRatePercent();
    if (this$federalRatePercent == null ? other$federalRatePercent != null : !this$federalRatePercent.equals(other$federalRatePercent)) return false;
    final java.lang.Object this$lowIncomePayment = this.getLowIncomePayment();
    final java.lang.Object other$lowIncomePayment = other.getLowIncomePayment();
    if (this$lowIncomePayment == null ? other$lowIncomePayment != null : !this$lowIncomePayment.equals(other$lowIncomePayment)) return false;
    final java.lang.Object this$lowIncomePaymentPenaltyAmount = this.getLowIncomePaymentPenaltyAmount();
    final java.lang.Object other$lowIncomePaymentPenaltyAmount = other.getLowIncomePaymentPenaltyAmount();
    if (this$lowIncomePaymentPenaltyAmount == null ? other$lowIncomePaymentPenaltyAmount != null : !this$lowIncomePaymentPenaltyAmount.equals(other$lowIncomePaymentPenaltyAmount)) return false;
    final java.lang.Object this$lowIncomePaymentPercent = this.getLowIncomePaymentPercent();
    final java.lang.Object other$lowIncomePaymentPercent = other.getLowIncomePaymentPercent();
    if (this$lowIncomePaymentPercent == null ? other$lowIncomePaymentPercent != null : !this$lowIncomePaymentPercent.equals(other$lowIncomePaymentPercent)) return false;
    final java.lang.Object this$nationalLaborPercent = this.getNationalLaborPercent();
    final java.lang.Object other$nationalLaborPercent = other.getNationalLaborPercent();
    if (this$nationalLaborPercent == null ? other$nationalLaborPercent != null : !this$nationalLaborPercent.equals(other$nationalLaborPercent)) return false;
    final java.lang.Object this$nationalNonLaborPercent = this.getNationalNonLaborPercent();
    final java.lang.Object other$nationalNonLaborPercent = other.getNationalNonLaborPercent();
    if (this$nationalNonLaborPercent == null ? other$nationalNonLaborPercent != null : !this$nationalNonLaborPercent.equals(other$nationalNonLaborPercent)) return false;
    final java.lang.Object this$nationalThresholdAdjustmentAmount = this.getNationalThresholdAdjustmentAmount();
    final java.lang.Object other$nationalThresholdAdjustmentAmount = other.getNationalThresholdAdjustmentAmount();
    if (this$nationalThresholdAdjustmentAmount == null ? other$nationalThresholdAdjustmentAmount != null : !this$nationalThresholdAdjustmentAmount.equals(other$nationalThresholdAdjustmentAmount)) return false;
    final java.lang.Object this$outlierPayment = this.getOutlierPayment();
    final java.lang.Object other$outlierPayment = other.getOutlierPayment();
    if (this$outlierPayment == null ? other$outlierPayment != null : !this$outlierPayment.equals(other$outlierPayment)) return false;
    final java.lang.Object this$outlierPenaltyAmount = this.getOutlierPenaltyAmount();
    final java.lang.Object other$outlierPenaltyAmount = other.getOutlierPenaltyAmount();
    if (this$outlierPenaltyAmount == null ? other$outlierPenaltyAmount != null : !this$outlierPenaltyAmount.equals(other$outlierPenaltyAmount)) return false;
    final java.lang.Object this$outlierThresholdAmount = this.getOutlierThresholdAmount();
    final java.lang.Object other$outlierThresholdAmount = other.getOutlierThresholdAmount();
    if (this$outlierThresholdAmount == null ? other$outlierThresholdAmount != null : !this$outlierThresholdAmount.equals(other$outlierThresholdAmount)) return false;
    final java.lang.Object this$pricedCaseMixGroupCode = this.getPricedCaseMixGroupCode();
    final java.lang.Object other$pricedCaseMixGroupCode = other.getPricedCaseMixGroupCode();
    if (this$pricedCaseMixGroupCode == null ? other$pricedCaseMixGroupCode != null : !this$pricedCaseMixGroupCode.equals(other$pricedCaseMixGroupCode)) return false;
    final java.lang.Object this$ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
    final java.lang.Object other$ruralAdjustmentPercent = other.getRuralAdjustmentPercent();
    if (this$ruralAdjustmentPercent == null ? other$ruralAdjustmentPercent != null : !this$ruralAdjustmentPercent.equals(other$ruralAdjustmentPercent)) return false;
    final java.lang.Object this$standardPayment = this.getStandardPayment();
    final java.lang.Object other$standardPayment = other.getStandardPayment();
    if (this$standardPayment == null ? other$standardPayment != null : !this$standardPayment.equals(other$standardPayment)) return false;
    final java.lang.Object this$submittedCaseMixGroupCode = this.getSubmittedCaseMixGroupCode();
    final java.lang.Object other$submittedCaseMixGroupCode = other.getSubmittedCaseMixGroupCode();
    if (this$submittedCaseMixGroupCode == null ? other$submittedCaseMixGroupCode != null : !this$submittedCaseMixGroupCode.equals(other$submittedCaseMixGroupCode)) return false;
    final java.lang.Object this$teachingPayment = this.getTeachingPayment();
    final java.lang.Object other$teachingPayment = other.getTeachingPayment();
    if (this$teachingPayment == null ? other$teachingPayment != null : !this$teachingPayment.equals(other$teachingPayment)) return false;
    final java.lang.Object this$teachingPaymentPenaltyAmount = this.getTeachingPaymentPenaltyAmount();
    final java.lang.Object other$teachingPaymentPenaltyAmount = other.getTeachingPaymentPenaltyAmount();
    if (this$teachingPaymentPenaltyAmount == null ? other$teachingPaymentPenaltyAmount != null : !this$teachingPaymentPenaltyAmount.equals(other$teachingPaymentPenaltyAmount)) return false;
    final java.lang.Object this$totalPenaltyAmount = this.getTotalPenaltyAmount();
    final java.lang.Object other$totalPenaltyAmount = other.getTotalPenaltyAmount();
    if (this$totalPenaltyAmount == null ? other$totalPenaltyAmount != null : !this$totalPenaltyAmount.equals(other$totalPenaltyAmount)) return false;
    final java.lang.Object this$transferPercent = this.getTransferPercent();
    final java.lang.Object other$transferPercent = other.getTransferPercent();
    if (this$transferPercent == null ? other$transferPercent != null : !this$transferPercent.equals(other$transferPercent)) return false;
    return true;
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  protected boolean canEqual(final java.lang.Object other) {
    return other instanceof IrfPaymentData;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public int hashCode() {
    final int PRIME = 59;
    int result = super.hashCode();
    result = result * PRIME + this.getAverageLengthOfStay();
    result = result * PRIME + this.getLengthOfStay();
    result = result * PRIME + this.getLifetimeReserveDaysUsed();
    result = result * PRIME + this.getRegularDaysUsed();
    final java.lang.Object $budgetNeutralityConversionAmount = this.getBudgetNeutralityConversionAmount();
    result = result * PRIME + ($budgetNeutralityConversionAmount == null ? 43 : $budgetNeutralityConversionAmount.hashCode());
    final java.lang.Object $caseMixGroupRelativeWeight = this.getCaseMixGroupRelativeWeight();
    result = result * PRIME + ($caseMixGroupRelativeWeight == null ? 43 : $caseMixGroupRelativeWeight.hashCode());
    final java.lang.Object $chargeOutlierThresholdAmount = this.getChargeOutlierThresholdAmount();
    result = result * PRIME + ($chargeOutlierThresholdAmount == null ? 43 : $chargeOutlierThresholdAmount.hashCode());
    final java.lang.Object $costOutlierThresholdIdentifier = this.getCostOutlierThresholdIdentifier();
    result = result * PRIME + ($costOutlierThresholdIdentifier == null ? 43 : $costOutlierThresholdIdentifier.hashCode());
    final java.lang.Object $facilityCosts = this.getFacilityCosts();
    result = result * PRIME + ($facilityCosts == null ? 43 : $facilityCosts.hashCode());
    final java.lang.Object $facilityRatePercent = this.getFacilityRatePercent();
    result = result * PRIME + ($facilityRatePercent == null ? 43 : $facilityRatePercent.hashCode());
    final java.lang.Object $facilitySpecificPayment = this.getFacilitySpecificPayment();
    result = result * PRIME + ($facilitySpecificPayment == null ? 43 : $facilitySpecificPayment.hashCode());
    final java.lang.Object $facilitySpecificRatePreBlend = this.getFacilitySpecificRatePreBlend();
    result = result * PRIME + ($facilitySpecificRatePreBlend == null ? 43 : $facilitySpecificRatePreBlend.hashCode());
    final java.lang.Object $federalPaymentAmount = this.getFederalPaymentAmount();
    result = result * PRIME + ($federalPaymentAmount == null ? 43 : $federalPaymentAmount.hashCode());
    final java.lang.Object $federalPenaltyAmount = this.getFederalPenaltyAmount();
    result = result * PRIME + ($federalPenaltyAmount == null ? 43 : $federalPenaltyAmount.hashCode());
    final java.lang.Object $federalRatePercent = this.getFederalRatePercent();
    result = result * PRIME + ($federalRatePercent == null ? 43 : $federalRatePercent.hashCode());
    final java.lang.Object $lowIncomePayment = this.getLowIncomePayment();
    result = result * PRIME + ($lowIncomePayment == null ? 43 : $lowIncomePayment.hashCode());
    final java.lang.Object $lowIncomePaymentPenaltyAmount = this.getLowIncomePaymentPenaltyAmount();
    result = result * PRIME + ($lowIncomePaymentPenaltyAmount == null ? 43 : $lowIncomePaymentPenaltyAmount.hashCode());
    final java.lang.Object $lowIncomePaymentPercent = this.getLowIncomePaymentPercent();
    result = result * PRIME + ($lowIncomePaymentPercent == null ? 43 : $lowIncomePaymentPercent.hashCode());
    final java.lang.Object $nationalLaborPercent = this.getNationalLaborPercent();
    result = result * PRIME + ($nationalLaborPercent == null ? 43 : $nationalLaborPercent.hashCode());
    final java.lang.Object $nationalNonLaborPercent = this.getNationalNonLaborPercent();
    result = result * PRIME + ($nationalNonLaborPercent == null ? 43 : $nationalNonLaborPercent.hashCode());
    final java.lang.Object $nationalThresholdAdjustmentAmount = this.getNationalThresholdAdjustmentAmount();
    result = result * PRIME + ($nationalThresholdAdjustmentAmount == null ? 43 : $nationalThresholdAdjustmentAmount.hashCode());
    final java.lang.Object $outlierPayment = this.getOutlierPayment();
    result = result * PRIME + ($outlierPayment == null ? 43 : $outlierPayment.hashCode());
    final java.lang.Object $outlierPenaltyAmount = this.getOutlierPenaltyAmount();
    result = result * PRIME + ($outlierPenaltyAmount == null ? 43 : $outlierPenaltyAmount.hashCode());
    final java.lang.Object $outlierThresholdAmount = this.getOutlierThresholdAmount();
    result = result * PRIME + ($outlierThresholdAmount == null ? 43 : $outlierThresholdAmount.hashCode());
    final java.lang.Object $pricedCaseMixGroupCode = this.getPricedCaseMixGroupCode();
    result = result * PRIME + ($pricedCaseMixGroupCode == null ? 43 : $pricedCaseMixGroupCode.hashCode());
    final java.lang.Object $ruralAdjustmentPercent = this.getRuralAdjustmentPercent();
    result = result * PRIME + ($ruralAdjustmentPercent == null ? 43 : $ruralAdjustmentPercent.hashCode());
    final java.lang.Object $standardPayment = this.getStandardPayment();
    result = result * PRIME + ($standardPayment == null ? 43 : $standardPayment.hashCode());
    final java.lang.Object $submittedCaseMixGroupCode = this.getSubmittedCaseMixGroupCode();
    result = result * PRIME + ($submittedCaseMixGroupCode == null ? 43 : $submittedCaseMixGroupCode.hashCode());
    final java.lang.Object $teachingPayment = this.getTeachingPayment();
    result = result * PRIME + ($teachingPayment == null ? 43 : $teachingPayment.hashCode());
    final java.lang.Object $teachingPaymentPenaltyAmount = this.getTeachingPaymentPenaltyAmount();
    result = result * PRIME + ($teachingPaymentPenaltyAmount == null ? 43 : $teachingPaymentPenaltyAmount.hashCode());
    final java.lang.Object $totalPenaltyAmount = this.getTotalPenaltyAmount();
    result = result * PRIME + ($totalPenaltyAmount == null ? 43 : $totalPenaltyAmount.hashCode());
    final java.lang.Object $transferPercent = this.getTransferPercent();
    result = result * PRIME + ($transferPercent == null ? 43 : $transferPercent.hashCode());
    return result;
  }

  @java.lang.Override
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public java.lang.String toString() {
    return "IrfPaymentData(averageLengthOfStay=" + this.getAverageLengthOfStay() + ", budgetNeutralityConversionAmount=" + this.getBudgetNeutralityConversionAmount() + ", caseMixGroupRelativeWeight=" + this.getCaseMixGroupRelativeWeight() + ", chargeOutlierThresholdAmount=" + this.getChargeOutlierThresholdAmount() + ", costOutlierThresholdIdentifier=" + this.getCostOutlierThresholdIdentifier() + ", facilityCosts=" + this.getFacilityCosts() + ", facilityRatePercent=" + this.getFacilityRatePercent() + ", facilitySpecificPayment=" + this.getFacilitySpecificPayment() + ", facilitySpecificRatePreBlend=" + this.getFacilitySpecificRatePreBlend() + ", federalPaymentAmount=" + this.getFederalPaymentAmount() + ", federalPenaltyAmount=" + this.getFederalPenaltyAmount() + ", federalRatePercent=" + this.getFederalRatePercent() + ", lengthOfStay=" + this.getLengthOfStay() + ", lifetimeReserveDaysUsed=" + this.getLifetimeReserveDaysUsed() + ", lowIncomePayment=" + this.getLowIncomePayment() + ", lowIncomePaymentPenaltyAmount=" + this.getLowIncomePaymentPenaltyAmount() + ", lowIncomePaymentPercent=" + this.getLowIncomePaymentPercent() + ", nationalLaborPercent=" + this.getNationalLaborPercent() + ", nationalNonLaborPercent=" + this.getNationalNonLaborPercent() + ", nationalThresholdAdjustmentAmount=" + this.getNationalThresholdAdjustmentAmount() + ", outlierPayment=" + this.getOutlierPayment() + ", outlierPenaltyAmount=" + this.getOutlierPenaltyAmount() + ", outlierThresholdAmount=" + this.getOutlierThresholdAmount() + ", pricedCaseMixGroupCode=" + this.getPricedCaseMixGroupCode() + ", regularDaysUsed=" + this.getRegularDaysUsed() + ", ruralAdjustmentPercent=" + this.getRuralAdjustmentPercent() + ", standardPayment=" + this.getStandardPayment() + ", submittedCaseMixGroupCode=" + this.getSubmittedCaseMixGroupCode() + ", teachingPayment=" + this.getTeachingPayment() + ", teachingPaymentPenaltyAmount=" + this.getTeachingPaymentPenaltyAmount() + ", totalPenaltyAmount=" + this.getTotalPenaltyAmount() + ", transferPercent=" + this.getTransferPercent() + ")";
  }

  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public IrfPaymentData() {
  }
}
