// Generated by delombok at Fri Aug 15 18:12:40 UTC 2025
package gov.cms.fiss.pricers.irf.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationContext;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.irf.core.tables.CmgTableEntry;
import gov.cms.fiss.pricers.irf.core.tables.DataTables;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;

public abstract class IrfPricerContext extends CalculationContext<IrfClaimPricingRequest, IrfClaimPricingResponse> {
  // Constants related to Length of Stay / calendar
  public static final BigDecimal HALF_DAY_LENGTH_OF_STAY = new BigDecimal("0.5");
  public static final int THREE_DAY_LENGTH_OF_STAY = 3;
  public static final int FOURTEEN_DAY_LENGTH_OF_STAY = 14;
  public static final int SIXTEEN_DAY_LENGTH_OF_STAY = 16;
  // Calculation Values
  public static final BigDecimal TWENTY_FIVE_PERCENT = new BigDecimal("0.25");
  public static final BigDecimal EIGHTY_PERCENT = new BigDecimal("0.80");
  public static final String YES_INDICATOR = "Y";
  // Case Mix Groups
  public static final String CMG_5001 = "5001";
  public static final String CMG_9999 = "9999";
  public static final String CMG_2103 = "2103";
  public static final String CMG_A5001 = "A5001";
  public static final String CMG_A5101 = "A5101";
  public static final String CMG_A5102 = "A5102";
  public static final String CMG_A5103 = "A5103";
  public static final String CMG_A5104 = "A5104";
  public static final BigDecimal FEDERAL_RATE_FULL = BigDecimal.ONE;
  public static final BigDecimal FEDERAL_RATE_TWO_THIRDS = new BigDecimal("0.6667");
  public static final BigDecimal FACILITY_RATE_0 = BigDecimal.ZERO;
  public static final BigDecimal FACILITY_RATE_ONE_THIRD = new BigDecimal("0.3333");
  public static final BigDecimal RURAL_ADJUSTMENT_NONE = BigDecimal.ONE;
  public static final BigDecimal TRANSFER_PERCENT_FULL = BigDecimal.ONE;
  // from ProvNewHold
  public static final String SPECIAL_PAY_INDICATOR = "1";
  public static final String PROV_WAIVER_STATE = "Y";
  public static final String PROV_BLEND_INDICATOR_3 = "3";
  public static final String PROV_BLEND_INDICATOR_4 = "4";
  public static final String PROV_CBSA_HOSPITAL_QUALITY_INDICATOR_1 = "1";
  private static final int DEFAULT_MAX_LIFETIME_RESERVE_DAYS = 60;
  // Per-Year constants
  private static final BigDecimal DEFAULT_NATIONAL_LABOR_PERCENTAGE = new BigDecimal("0.69294");
  private static final BigDecimal DEFAULT_NATIONAL_NON_LABOR_PERCENTAGE = new BigDecimal("0.30706");
  private static final BigDecimal DEFAULT_NATIONAL_THRESHOLD_ADJUSTMENT = new BigDecimal("8848.00");
  private static final BigDecimal DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT = new BigDecimal("15198.00");
  private static final BigDecimal DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT2 = new BigDecimal("14901.00");
  private static final BigDecimal DEFAULT_TRANSITION_RURAL_ADJUSTMENT = BigDecimal.ZERO;
  private static final BigDecimal DEFAULT_RURAL_ADJUSTMENT = new BigDecimal("1.1490");
  private static final BigDecimal DEFAULT_CALC_LOW_INCOME_PERCENTAGE = new BigDecimal("0.3177");
  private static final BigDecimal DEFAULT_CALC_TEACH = new BigDecimal("1.0163");
  private static final Set<String> ORTHOPEDIC_CMG_PREFIXES = new HashSet<>(Arrays.asList("07", "08", "09"));
  private static final Set<String> URBAN_TO_RURAL_PROVIDERS = new HashSet<>(Arrays.asList("013027", "08T009", "10T249", "14T011", "193044", "193079", "193096", "19T003", "19T144", "19T304", "28T023", "33T157", "34T015", "34T131", "393047", "39T151", "42T036", "42T067", "49T018", "50T002"));
  // Patient Status values
  private static final String PATIENT_STATUS_EXPIRED = "20";
  // Note: These codes were taken from 88 codes in the original COBOL
  private static final Set<String> PATIENT_STATUS_TRANSFERRED = new HashSet<>(Arrays.asList("02", "03", "61", "62", "63", "64", "82", "83", "89", "90", "91", "92"));
  // State variables
  // Lookup content
  @JsonIgnore
  protected final DataTables dataTables;
  /**
   * Corresponds to {@code WAGE-NEW-INDEX-RECORD-CBSA} from the COBOL source.
   */
  private CbsaWageIndexEntry cbsaWageIndexEntry;
  /**
   * Corresponds to {@code H-WK-DSH PIC 9(01)V9(04)} from the COBOL source.
   */
  private BigDecimal disproportionateShareAdjustment;
  /**
   * Corresponds to {@code H-TEACH-PCT PIC 9(01)V9(04)} from the COBOL source.
   */
  private BigDecimal teachPercent;
  /**
   * Corresponds to {@code P-NEW-FED-PPS-BLEND-IND PIC X} from the COBOL source.
   */
  private String ppsBlendIndicator;

  protected IrfPricerContext(IrfClaimPricingRequest input, IrfClaimPricingResponse output, DataTables dataTables) {
    super(input, output);
    this.dataTables = dataTables;
    initializeOutput();
  }

  protected void initializeOutput() {
    getOutput().setPaymentData(new IrfPaymentData());
    getOutput().getPaymentData().setTotalPayment(BigDecimalUtils.ZERO);
    getOutput().setCalculationVersion(getCalculationVersion());
    getOutput().setReturnCodeData(ResultCode.OK_00.toReturnCodeData());
    // From 3000-CALC-PAYMENT
    getPaymentData().setTransferPercent(IrfPricerContext.TRANSFER_PERCENT_FULL.setScale(4, RoundingMode.HALF_UP));
  }

  // Calculation data
  public static boolean isOrthopedicCmg(String cmgCode) {
    return ORTHOPEDIC_CMG_PREFIXES.contains(StringUtils.mid(cmgCode, 1, 2));
  }

  public static Set<String> getUrbanToRuralProviders() {
    return Collections.unmodifiableSet(URBAN_TO_RURAL_PROVIDERS);
  }

  @JsonIgnore
  public IrfClaimData getClaimData() {
    return getInput().getClaimData();
  }

  @JsonIgnore
  public InpatientProviderData getProviderData() {
    return getInput().getProviderData();
  }

  @JsonIgnore
  public IrfPaymentData getPaymentData() {
    return getOutput().getPaymentData();
  }

  @JsonIgnore
  public ResultCode getResultCode() {
    return ResultCode.fromCode(Integer.parseInt(getOutput().getReturnCodeData().getCode()));
  }

  @JsonIgnore
  public LocalDate getClaimDischargeDate() {
    return getClaimData().getDischargeDate();
  }

  /**
   * Determines if the given code matches the current output record code.
   */
  public boolean matchesReturnCode(ResultCode expectedCode) {
    return expectedCode.equals(ResultCode.fromCode(getResultCode().getCode()));
  }

  /**
   * Determines if the given CBSA is rural.
   */
  public boolean isRuralCbsa(String cbsa) {
    return cbsa.trim().matches("\\d{2}");
  }

  // Manage state
  @JsonIgnore
  public LocalDate getProviderEffectiveDate() {
    return getProviderData().getEffectiveDate();
  }

  @JsonIgnore
  public LocalDate getProviderFiscalYearBegin() {
    return getProviderData().getFiscalYearBeginDate();
  }

  public void applyResultCode(ResultCode resultCode) {
    applyResultCode(resultCode, resultCode.getDescription(), resultCode.getExplanation());
  }

  // Lookup content
  public void applyResultCode(ResultCode resultCode, String description, String explanation) {
    final String code = StringUtils.leftPad(String.valueOf(resultCode.getCode()), 2, "0");
    getOutput().getReturnCodeData().setCode(code);
    getOutput().getReturnCodeData().setDescription(description);
    getOutput().getReturnCodeData().setExplanation(explanation);
  }

  /**
   * Resets the prospective payment record back to initial/default values.
   */
  public void zeroPaymentRecord() {
    final IrfPaymentData zeroRecord = new IrfPaymentData();
    zeroRecord.setTotalPayment(BigDecimalUtils.ZERO);
    getOutput().setPaymentData(zeroRecord);
  }

  // Per-year value retrieval
  public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate providedEffectiveDate) {
    return dataTables.getCbsaWageIndexEntry(cbsa, providedEffectiveDate);
  }

  public CmgTableEntry getCmgEntry(String cmgCode) {
    return dataTables.getCmgEntry(cmgCode);
  }

  public BigDecimal getBudgetNeutralConversionAmount() {
    return DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT;
  }

  public BigDecimal getBudgetNeutralConversionAmount2() {
    return DEFAULT_BUDGET_NEUTRAL_CONVERSION_AMOUNT2;
  }

  public BigDecimal getCalcLowIncomePercentage() {
    return DEFAULT_CALC_LOW_INCOME_PERCENTAGE;
  }

  public BigDecimal getCalcTeach() {
    return DEFAULT_CALC_TEACH;
  }

  /**
   * Corresponds to {@code PPS-CALC-VERS-CD PIC X(05)} from the COBOL source.
   */
  public abstract String getCalculationVersion();

  public abstract LocalDate getFiscalYearEnd();

  public abstract LocalDate getFiscalYearStart();

  public int getMaxLifetimeReserveDays() {
    return DEFAULT_MAX_LIFETIME_RESERVE_DAYS;
  }

  /**
   * Corresponds to {@code PPS-NAT-LABOR-PCT PIC 9(01)V9(05)} from the COBOL source.
   */
  public BigDecimal getNationalLaborPercentage() {
    return DEFAULT_NATIONAL_LABOR_PERCENTAGE;
  }

  /**
   * Corresponds to {@code PPS-NAT-NONLABOR-PCT PIC 9(01)V9(05)} from the COBOL source.
   */
  public BigDecimal getNationalNonLaborPercentage() {
    return DEFAULT_NATIONAL_NON_LABOR_PERCENTAGE;
  }

  /**
   * Corresponds to {@code PPS-NAT-THRESHOLD-ADJ PIC 9(05)V9(02)} from the COBOL source.
   */
  public BigDecimal getNationalThresholdAdjustment() {
    return DEFAULT_NATIONAL_THRESHOLD_ADJUSTMENT;
  }

  public BigDecimal getTransitionRuralAdjustment() {
    return DEFAULT_TRANSITION_RURAL_ADJUSTMENT;
  }

  public BigDecimal getRuralAdjustment() {
    return DEFAULT_RURAL_ADJUSTMENT;
  }

  // Business methods
  public BigDecimal getWageIndexPercentAdjustment() {
    return BigDecimal.ZERO;
  }

  public BigDecimal getWageIndexPercentReductionCap() {
    return BigDecimal.ZERO;
  }

  // Claim data business methods
  public boolean hasPenalties() {
    return StringUtils.equalsAny(getClaimData().getOutlierSpecialPaymentIndicator(), "2", "3");
  }

  // It feels like this should maybe be just 'isOutlier', and look for "2", but I don't know at the
  // moment what these indicators mean so I'm exactly replicating what was here before.
  public boolean isNotOutlier() {
    return StringUtils.equalsAny(getClaimData().getOutlierSpecialPaymentIndicator(), "1", "3");
  }

  public boolean isPatientExpired() {
    return getClaimData().getPatientStatus().equals(PATIENT_STATUS_EXPIRED);
  }

  public boolean isPatientTransferred() {
    return PATIENT_STATUS_TRANSFERRED.contains(getClaimData().getPatientStatus());
  }

  public boolean isTransferCase() {
    return PATIENT_STATUS_TRANSFERRED.contains(getClaimData().getPatientStatus()) && getPaymentData().getLengthOfStay() < getPaymentData().getAverageLengthOfStay();
  }

  /**
   * Corresponds to {@code WAGE-NEW-INDEX-RECORD-CBSA} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public CbsaWageIndexEntry getCbsaWageIndexEntry() {
    return this.cbsaWageIndexEntry;
  }

  /**
   * Corresponds to {@code WAGE-NEW-INDEX-RECORD-CBSA} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setCbsaWageIndexEntry(final CbsaWageIndexEntry cbsaWageIndexEntry) {
    this.cbsaWageIndexEntry = cbsaWageIndexEntry;
  }

  /**
   * Corresponds to {@code H-WK-DSH PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getDisproportionateShareAdjustment() {
    return this.disproportionateShareAdjustment;
  }

  /**
   * Corresponds to {@code H-WK-DSH PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setDisproportionateShareAdjustment(final BigDecimal disproportionateShareAdjustment) {
    this.disproportionateShareAdjustment = disproportionateShareAdjustment;
  }

  /**
   * Corresponds to {@code H-TEACH-PCT PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public BigDecimal getTeachPercent() {
    return this.teachPercent;
  }

  /**
   * Corresponds to {@code H-TEACH-PCT PIC 9(01)V9(04)} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setTeachPercent(final BigDecimal teachPercent) {
    this.teachPercent = teachPercent;
  }

  /**
   * Corresponds to {@code P-NEW-FED-PPS-BLEND-IND PIC X} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public String getPpsBlendIndicator() {
    return this.ppsBlendIndicator;
  }

  /**
   * Corresponds to {@code P-NEW-FED-PPS-BLEND-IND PIC X} from the COBOL source.
   */
  @java.lang.SuppressWarnings("all")
  @lombok.Generated
  public void setPpsBlendIndicator(final String ppsBlendIndicator) {
    this.ppsBlendIndicator = ppsBlendIndicator;
  }
}
