/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.common.util;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Objects;
import lombok.Generated;

public final class LocalDateUtils {
    public static int toFiscalYear(LocalDate providedDate) {
        if (null == providedDate) {
            return -1;
        }
        if (providedDate.getMonthValue() < 10) {
            return providedDate.getYear();
        }
        return providedDate.getYear() + 1;
    }

    public static LocalDate fiscalYearEnd(int providedYear) {
        return LocalDate.of(providedYear, 9, 30);
    }

    public static LocalDate fiscalYearEnd(LocalDate providedDate) {
        if (null == providedDate) {
            return null;
        }
        return LocalDateUtils.fiscalYearEnd(LocalDateUtils.toFiscalYear(providedDate));
    }

    public static LocalDate fiscalYearStart(int providedYear) {
        return LocalDate.of(providedYear - 1, 10, 1);
    }

    public static LocalDate fiscalYearStart(LocalDate providedDate) {
        if (null == providedDate) {
            return null;
        }
        return LocalDateUtils.fiscalYearStart(LocalDateUtils.toFiscalYear(providedDate));
    }

    public static boolean inFiscalYear(LocalDate targetDate, LocalDate yearDate) {
        if (null == targetDate) {
            return false;
        }
        return LocalDateUtils.inFiscalYear(targetDate, LocalDateUtils.toFiscalYear(yearDate));
    }

    public static boolean inFiscalYear(LocalDate targetDate, int fiscalYear) {
        return LocalDateUtils.toFiscalYear(targetDate) == fiscalYear;
    }

    public static boolean inRange(LocalDate targetDate, LocalDate rangeStart, LocalDate rangeEnd) {
        return LocalDateUtils.inRange(targetDate, rangeStart, true, rangeEnd, true);
    }

    public static boolean inRangeExclusive(LocalDate targetDate, LocalDate rangeStart, LocalDate rangeEnd) {
        return LocalDateUtils.inRange(targetDate, rangeStart, false, rangeEnd, false);
    }

    public static boolean inRange(LocalDate targetDate, LocalDate rangeStart, boolean isStartInclusive, LocalDate rangeEnd, boolean isEndInclusive) {
        boolean withinStart = isStartInclusive ? LocalDateUtils.isAfterOrEqual(targetDate, rangeStart) : LocalDateUtils.isAfter(targetDate, rangeStart);
        boolean withinEnd = isEndInclusive ? LocalDateUtils.isBeforeOrEqual(targetDate, rangeEnd) : LocalDateUtils.isBefore(targetDate, rangeEnd);
        return withinStart && withinEnd;
    }

    public static boolean isAfter(LocalDate targetDate, LocalDate referenceDate) {
        if (null == referenceDate) {
            return true;
        }
        if (null == targetDate) {
            return false;
        }
        return targetDate.isAfter(referenceDate);
    }

    public static boolean isAfterOrEqual(LocalDate targetDate, LocalDate referenceDate) {
        return LocalDateUtils.isAfter(targetDate, referenceDate) || Objects.equals(targetDate, referenceDate);
    }

    public static boolean isBefore(LocalDate targetDate, LocalDate referenceDate) {
        if (null == referenceDate) {
            return false;
        }
        if (null == targetDate) {
            return true;
        }
        return targetDate.isBefore(referenceDate);
    }

    public static boolean isBeforeOrEqual(LocalDate targetDate, LocalDate referenceDate) {
        return LocalDateUtils.isBefore(targetDate, referenceDate) || Objects.equals(targetDate, referenceDate);
    }

    public static LocalDate fromYearFormat(String formattedDate) {
        if (null == formattedDate) {
            return null;
        }
        try {
            return DateTimeFormatter.BASIC_ISO_DATE.parse((CharSequence)formattedDate, LocalDate::from);
        }
        catch (DateTimeParseException dtpe) {
            return null;
        }
    }

    public static String toYearFormat(LocalDate targetDate) {
        if (null == targetDate) {
            return null;
        }
        return DateTimeFormatter.BASIC_ISO_DATE.format(targetDate);
    }

    public static LocalDate calendarYearEnd(LocalDate providedDate) {
        if (null == providedDate) {
            return null;
        }
        return providedDate.withDayOfYear(providedDate.lengthOfYear());
    }

    public static LocalDate calendarYearStart(LocalDate providedDate) {
        if (null == providedDate) {
            return null;
        }
        return providedDate.withDayOfYear(1);
    }

    public static boolean inCalendarYear(LocalDate targetDate, LocalDate yearDate) {
        if (null == targetDate || null == yearDate) {
            return false;
        }
        return LocalDateUtils.inCalendarYear(targetDate, yearDate.getYear());
    }

    public static boolean inCalendarYear(LocalDate targetDate, int calendarYear) {
        return targetDate.getYear() == calendarYear;
    }

    @Generated
    private LocalDateUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

