/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules;

import gov.cms.fiss.pricers.common.api.InpatientProviderData;
import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculateLowIncomePaymentPercent
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        InpatientProviderData providerData = calculationContext.getProviderData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        calculationContext.setDisproportionateShareAdjustment(providerData.getSupplementalSecurityIncomeRatio().add(providerData.getMedicaidRatio()).setScale(4, RoundingMode.HALF_UP));
        paymentData.setLowIncomePaymentPercent(BigDecimalUtils.pow(calculationContext.getDisproportionateShareAdjustment().add(BigDecimal.ONE), calculationContext.getCalcLowIncomePercentage(), 10).subtract(BigDecimal.ONE).setScale(4, RoundingMode.HALF_UP));
    }
}

