/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.bill_review;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimData;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import gov.cms.fiss.pricers.irf.core.ResultCode;

public class ValidateCoveredDays
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public boolean shouldExecute(IrfPricerContext calculationContext) {
        return calculationContext.matchesReturnCode(ResultCode.OK_00);
    }

    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfClaimData claimData = calculationContext.getClaimData();
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        paymentData.setLifetimeReserveDaysUsed(claimData.getLifetimeReserveDays());
        if (claimData.getCoveredDays() == 0 && paymentData.getLengthOfStay() > 0) {
            calculationContext.applyResultCode(ResultCode.INVALID_NBR_COVERED_DAYS_62, ResultCode.INVALID_NBR_COVERED_DAYS_62.getDescription(), "Number of billed days must be numeric and not equal to zero if length of stay is greater than zero");
        }
    }
}

