/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.rules.finalize_payment;

import gov.cms.fiss.pricers.common.application.rules.CalculationRule;
import gov.cms.fiss.pricers.common.util.BigDecimalUtils;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingRequest;
import gov.cms.fiss.pricers.irf.api.v2.IrfClaimPricingResponse;
import gov.cms.fiss.pricers.irf.api.v2.IrfPaymentData;
import gov.cms.fiss.pricers.irf.core.IrfPricerContext;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class CalculatePaymentAmounts
implements CalculationRule<IrfClaimPricingRequest, IrfClaimPricingResponse, IrfPricerContext> {
    @Override
    public void calculate(IrfPricerContext calculationContext) {
        IrfPaymentData paymentData = calculationContext.getPaymentData();
        if (BigDecimalUtils.equals(BigDecimal.ONE, paymentData.getFederalRatePercent())) {
            paymentData.setFacilitySpecificPayment(BigDecimalUtils.ZERO);
        } else {
            paymentData.setFederalPaymentAmount(paymentData.getFederalRatePercent().multiply(paymentData.getFederalPaymentAmount()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setFacilitySpecificPayment(paymentData.getFacilityRatePercent().multiply(paymentData.getFacilitySpecificRatePreBlend()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setOutlierPayment(paymentData.getFederalRatePercent().multiply(paymentData.getOutlierPayment()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setTeachingPayment(paymentData.getFederalRatePercent().multiply(paymentData.getTeachingPaymentPenaltyAmount()).setScale(2, RoundingMode.HALF_UP));
            paymentData.setLowIncomePayment(paymentData.getFederalRatePercent().multiply(paymentData.getLowIncomePayment()).setScale(2, RoundingMode.HALF_UP));
        }
    }
}

