/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.fiss.pricers.irf.core.tables;

import gov.cms.fiss.pricers.common.csv.CsvIngestionConfiguration;
import gov.cms.fiss.pricers.irf.IrfPricerConfiguration;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexEntry;
import gov.cms.fiss.pricers.irf.core.tables.CbsaWageIndexLookupGenerator;
import gov.cms.fiss.pricers.irf.core.tables.CmgTableEntry;
import gov.cms.fiss.pricers.irf.core.tables.CmgTableEntryLookupGenerator;
import java.time.LocalDate;
import java.util.Map;
import java.util.NavigableMap;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;

public class DataTables {
    private static final Map<Integer, DataTables> YEAR_LOOKUP = new ConcurrentHashMap<Integer, DataTables>();
    private final Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable;
    private final Map<String, CmgTableEntry> cmgTable;

    public DataTables(Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> cbsaTable, Map<String, CmgTableEntry> cmgTable) {
        this.cbsaTable = cbsaTable;
        this.cmgTable = cmgTable;
    }

    public static DataTables forYear(int pricerYear) {
        return YEAR_LOOKUP.get(pricerYear);
    }

    public static void loadDataTables(IrfPricerConfiguration pricerConfiguration) {
        CsvIngestionConfiguration csvIngestionConfiguration = pricerConfiguration.getCsvIngestionConfiguration();
        CbsaWageIndexLookupGenerator cbsaLookupProvider = new CbsaWageIndexLookupGenerator(csvIngestionConfiguration);
        CmgTableEntryLookupGenerator cmgTableEntryLookupGenerator = new CmgTableEntryLookupGenerator(csvIngestionConfiguration);
        for (int pricerYear : pricerConfiguration.getSupportedYears()) {
            YEAR_LOOKUP.put(pricerYear, new DataTables(cbsaLookupProvider.generate(pricerYear), cmgTableEntryLookupGenerator.generate(pricerYear)));
        }
    }

    public CbsaWageIndexEntry getCbsaWageIndexEntry(String cbsa, LocalDate effectiveDate) {
        NavigableMap<LocalDate, CbsaWageIndexEntry> entries = this.cbsaTable.get(cbsa);
        if (entries != null) {
            Map.Entry<LocalDate, CbsaWageIndexEntry> entry = entries.floorEntry(effectiveDate);
            return null == entry ? null : entry.getValue();
        }
        return null;
    }

    public CmgTableEntry getCmgEntry(String cmgCode) {
        return this.cmgTable.get(cmgCode);
    }

    @Generated
    public Map<String, NavigableMap<LocalDate, CbsaWageIndexEntry>> getCbsaTable() {
        return this.cbsaTable;
    }
}

