/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.claim;

import gov.cms.hh.claim.ClaimElementBase;
import gov.cms.hh.claim.ClaimElementCollection;
import gov.cms.hh.claim.ClaimElementCollectionIF;
import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.claim.DateFromIF;
import gov.cms.hh.claim.HippsCode;
import gov.cms.hh.claim.HippsCodeIF;
import gov.cms.hh.claim.OasisResponseIF;
import gov.cms.hh.claim.PeriodTimingIF;
import gov.cms.hh.claim.ReferralSourceIF;
import gov.cms.hh.claim.ReturnCode;
import gov.cms.hh.claim.ValidityFlag;
import gov.cms.hh.data.meta.enumer.EditId_EN;
import gov.cms.hh.data.meta.enumer.EditType_EN;
import gov.cms.hh.diagnosis.DiagnosisIF;
import gov.cms.hh.logic.validation.Edit;
import gov.cms.hh.logic.validation.EditCollection;
import gov.cms.hh.logic.validation.EditCollectionIF;
import java.util.Comparator;
import java.util.Optional;
import java.util.logging.Level;

public class Claim
extends ClaimElementBase
implements ClaimIF {
    private static final long serialVersionUID = 1L;
    private ClaimElementCollectionIF<ValidityFlag> validityFlags;
    private ClaimElementCollectionIF<ReturnCode> returnCodes;
    private ClaimElementCollectionIF<OasisResponseIF> oasisFields;
    private HippsCodeIF hippsCode = new HippsCode();
    private ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses = new ClaimElementCollection<DiagnosisIF>();
    private DiagnosisIF primaryDiagnosis;
    private ReferralSourceIF referralSource;
    private DateFromIF dateFrom;
    private PeriodTimingIF periodTiming;
    private String claimId;
    private String grouperVersion;

    public String toString() {
        return "Claim{validityFlags=" + this.validityFlags + ", returnCodes=" + this.returnCodes + ", oasisFields=" + this.oasisFields + ", hippsCode=" + this.hippsCode + ", secondaryDiagnoses=" + this.secondaryDiagnoses + ", primaryDiagnosis=" + this.primaryDiagnosis + ", referralSource=" + this.referralSource + ", dateFrom=" + this.dateFrom + ", periodTiming=" + this.periodTiming + ", ClaimId=" + this.claimId + '}';
    }

    public Claim() {
        this.oasisFields = new ClaimElementCollection<OasisResponseIF>();
        this.returnCodes = new ClaimElementCollection<ReturnCode>();
        this.validityFlags = new ClaimElementCollection<ValidityFlag>();
    }

    @Override
    public ClaimElementCollectionIF<ValidityFlag> getValidityFlags() {
        return this.validityFlags;
    }

    @Override
    public void setValidityFlags(ClaimElementCollectionIF<ValidityFlag> validityFlags) {
        this.validityFlags = validityFlags;
    }

    @Override
    public ClaimElementCollectionIF<ReturnCode> getReturnCodes() {
        return this.returnCodes;
    }

    @Override
    public void setReturnCodes(ClaimElementCollectionIF<ReturnCode> returnCodes) {
        this.returnCodes = returnCodes;
    }

    @Override
    public ClaimElementCollectionIF<OasisResponseIF> getOasisFields() {
        return this.oasisFields;
    }

    @Override
    public void setOasisFields(ClaimElementCollectionIF<OasisResponseIF> oasisFields) {
        this.oasisFields = oasisFields;
    }

    @Override
    public HippsCodeIF getHippsCode() {
        return this.hippsCode;
    }

    @Override
    public void setHippsCode(HippsCodeIF hippsCode) {
        this.hippsCode = hippsCode;
    }

    @Override
    public ClaimElementCollectionIF<DiagnosisIF> getSecondaryDiagnoses() {
        return this.secondaryDiagnoses;
    }

    @Override
    public void setSecondaryDiagnoses(ClaimElementCollectionIF<DiagnosisIF> secondaryDiagnoses) {
        this.secondaryDiagnoses = secondaryDiagnoses;
    }

    @Override
    public DiagnosisIF getPrimaryDiagnosis() {
        return this.primaryDiagnosis;
    }

    @Override
    public void setPrimaryDiagnosis(DiagnosisIF primaryDiagnosis) {
        this.primaryDiagnosis = primaryDiagnosis;
    }

    @Override
    public ReferralSourceIF getReferralSource() {
        return this.referralSource;
    }

    @Override
    public void setReferralSource(ReferralSourceIF referralSource) {
        this.referralSource = referralSource;
    }

    @Override
    public DateFromIF getDateFrom() {
        return this.dateFrom;
    }

    @Override
    public void setDateFrom(DateFromIF dateFrom) {
        this.dateFrom = dateFrom;
    }

    @Override
    public PeriodTimingIF getPeriodTiming() {
        return this.periodTiming;
    }

    @Override
    public void setPeriodTiming(PeriodTimingIF periodTiming) {
        this.periodTiming = periodTiming;
    }

    @Override
    public String getClaimId() {
        return this.claimId;
    }

    @Override
    public void setClaimId(String ClaimId) {
        this.claimId = ClaimId;
    }

    @Override
    public ReturnCode getSingleReturnCode() {
        Optional<ReturnCode> retGrc;
        if (!this.returnCodes.getCollection().isEmpty() && (retGrc = this.returnCodes.getCollection().stream().min(Comparator.comparing(ReturnCode::getId))).isPresent()) {
            return retGrc.get();
        }
        return new ReturnCode(50, "Fatal error - Component corrupted or not set up");
    }

    @Override
    public ValidityFlag getSingleValidityFlag() {
        Optional<ValidityFlag> retVal;
        if (!this.validityFlags.getCollection().isEmpty() && (retVal = this.validityFlags.getCollection().stream().min(Comparator.comparing(ValidityFlag::getValue))).isPresent()) {
            return retVal.get();
        }
        return new ValidityFlag("00", "Validity Flag not used");
    }

    @Override
    public String getGrouperVersion() {
        return this.grouperVersion;
    }

    @Override
    public void setGrouperVersion(String grouperVersion) {
        this.grouperVersion = grouperVersion;
    }

    @Override
    public EditCollectionIF getClaimEdits() {
        EditCollection retEdColl = new EditCollection();
        retEdColl.addEdits(this.getEditCollection().getEdits());
        if (this.dateFrom != null) {
            retEdColl.addEdits(this.dateFrom.getEditCollection().getEdits());
        }
        if (this.periodTiming != null) {
            retEdColl.addEdits(this.periodTiming.getEditCollection().getEdits());
        }
        if (this.referralSource != null) {
            retEdColl.addEdits(this.referralSource.getEditCollection().getEdits());
        }
        if (this.primaryDiagnosis != null) {
            retEdColl.addEdits(this.primaryDiagnosis.getEditCollection().getEdits());
        }
        retEdColl.addEdits(this.secondaryDiagnoses.getEditCollection().getEdits());
        this.secondaryDiagnoses.getCollection().forEach(sdx -> retEdColl.addEdits(sdx.getEditCollection().getEdits()));
        retEdColl.addEdits(this.oasisFields.getEditCollection().getEdits());
        this.oasisFields.getCollection().forEach(field -> retEdColl.addEdits(field.getEditCollection().getEdits()));
        retEdColl.addEdits(this.hippsCode.getEditCollection().getEdits());
        this.returnCodes.getCollection().forEach(returnCode -> retEdColl.addEdit(new Edit(EditId_EN.VALUE_RETURN, returnCode.toString(), EditType_EN.INFO, Level.INFO)));
        this.validityFlags.getCollection().forEach(validityFlag -> retEdColl.addEdit(new Edit(EditId_EN.VALUE_RETURN, validityFlag.toString(), EditType_EN.INFO, Level.INFO)));
        return retEdColl;
    }

    @Override
    public boolean hasReturnCode(int returnCode) {
        for (ReturnCode rc : this.returnCodes.getCollection()) {
            if (rc.getId() != returnCode) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean hasValidityFlag(String validityFlag) {
        return this.validityFlags.getCollection().stream().anyMatch(flag -> flag.getValue().equalsIgnoreCase(validityFlag.trim()));
    }
}

