/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.data.meta.enumer;

import gov.cms.hh.common.abstr.DescribableIF;
import gov.cms.hh.common.abstr.IdentifiableIF;

/**
 *
 * @author CMS
 */
public enum ComorbidityLevel_EN implements DescribableIF, IdentifiableIF {

    // Claim Period Timing

    /**
     *
     */

    NO_COMORBIDITY(1,"No comorbidity"),

    /**
     *
     */
    LOW_COMORBIDITY(2,"Low comorbidity"),

    /**
     *
     */
    HIGH_COMORBIDITY(3,"High comorbidity")
    
    ;
    
    private String description;
    private int id;

    private ComorbidityLevel_EN(int id, String description) {
        this.id = id;
        this.description = description;
    }

    @Override
    public String getDescription() {
        return description;
    }

    @Override
    public void setDescription(String description) {
        this.description = description;
    }

    @Override
    public String toString() {
        return description;
    }

    /**
     * @return the id
     */
    @Override
    public int getId() {
        return id;
    }

    /**
     * @param id the id to set
     */
    @Override
    public void setId(int id) {
        this.id = id;
    }

}
