/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.grouper.utility;

import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import java.util.StringJoiner;

/**
 *
 * @author CMS
 */
public class Utility {

    final static String DELIMITER_COMMA = ",";
    final static String DELIMITER_TAB = "\t";

    /**
     *
     * @param list
     * @return
     */
    public static int sum(List<Integer> list) {
        if (list == null || list.size() < 1) {
            return 0;
        }

        int sum = 0;
        for (Integer i : list) {
            sum = sum + i;
        }

        return sum;
    }

    /**
     *
     * @param list
     * @return
     */
    public static String join(List<String> list) {
        return join(list, DELIMITER_COMMA);
    }

    /**
     *
     * @param list
     * @param delimiter
     * @return
     */
    public static String join(List<String> list, String delimiter) {
        if (list == null) {
            return null;
        }
        String del = (delimiter == null ? DELIMITER_COMMA : delimiter);
        StringJoiner joiner = new StringJoiner(del);
        list.forEach((s) -> {
            joiner.add(s);
        });
        return joiner.toString();
    }

    /**
     * Check JVM
     */
    public static void detectJvm() {

//        final String[] KEYS = {
//            "sun.arch.data.model",
//            "com.ibm.vm.bitmode",
//            "os.arch",
//            "java.version"
//        };
        System.out.println("***** Java configuration *****");

//        for (String key : KEYS) {
//            String property = System.getProperty(key);
//            System.out.println(key + "=" + property);
//        }
        Properties p = System.getProperties();
        Enumeration keys = p.keys();
        while (keys.hasMoreElements()) {
            String key = (String) keys.nextElement();
            String value = (String) p.get(key);
            System.out.println(key + ": " + value);
        }

    }

    /**
     *
     * @param s
     * @param n
     * @return
     */
    public static String adjustLine(String s, int n) {
        String line;
        if (s.length() == n) {
            return s;
        } else {
            if (s.length() > n) {
                line = s.substring(0, n);
            } else {
                line = Utility.padRight(s, n);
            }
        }
        return line;
    }

    /**
     *
     * @param s
     * @param n
     * @return
     */
    public static String padRight(String s, int n) {
        return String.format("%-" + n + "s", s);
    }

    /**
     *
     * @param s
     * @param n
     * @return
     */
    public static String padLeft(String s, int n) {
        return String.format("%" + n + "s", s);
    }

}
