/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.logic.processor;

import gov.cms.hh.claim.ClaimIF;
import gov.cms.hh.grouper.DataManagerIF;
import java.util.LinkedList;
import java.util.List;

/**
 *
 * @author CMS
 */
public class HippsProcessor {

    /**
     *
     * Process claim
     * @param claim
     * @param dataManager
     */
    public void process(final ClaimIF claim, final DataManagerIF dataManager) {

        // Build HIPPS position logic pool
        List<HippsPositionIF> steps = new LinkedList<>();

        steps.add(new HippsPosition1(claim, dataManager));
        steps.add(new HippsPosition2(claim, dataManager));
        steps.add(new HippsPosition3(claim, dataManager));
        steps.add(new HippsPosition4(claim, dataManager));
        steps.add(new HippsPosition5(claim, dataManager));

        // Execute logic
        executeLogic(steps);
        
    }
    
    private void executeLogic(List<HippsPositionIF> steps) {
        
        // Execute logic steps sequentially
        for (HippsPositionIF step : steps) {
            step.validate();
            step.calculate();
        }
    }

}
