/*
 * Decompiled with CFR 0.152.
 */
package com.utilities.nodes;

import com.modal.constants.FunctionalImpairments;
import com.modal.display.EarlyLateComboBox;
import com.modal.display.ReferralSourceComboBox;
import com.utilities.component.ComponentManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.stream.Stream;
import javafx.collections.ObservableList;
import javafx.scene.control.ComboBox;

public class ComboBoxManager {
    public static void initComboBoxes(ArrayList<ComboBox> comboBoxes) {
        for (ComboBox comboBox : comboBoxes) {
            ArrayList<String> values = new ArrayList<String>();
            ArrayList<String> maxThreeValues = new ArrayList<String>(Arrays.asList("grooming", "dressUpper", "dressLower"));
            ArrayList<String> maxFourValues = new ArrayList<String>(Collections.singletonList("toileting"));
            ArrayList<String> maxFiveValues = new ArrayList<String>(Collections.singletonList("transferring"));
            ArrayList<String> maxSixValues = new ArrayList<String>(Arrays.asList("ambulation", "bathing"));
            if (comboBox.getId().endsWith("EL")) {
                Stream<EarlyLateComboBox> stream = Stream.of(EarlyLateComboBox.values());
                stream.forEach(s -> values.add(s.toString()));
            } else if (comboBox.getId().equalsIgnoreCase("referralSource")) {
                Stream<ReferralSourceComboBox> stream = Stream.of(ReferralSourceComboBox.values());
                stream.forEach(s -> values.add(s.toString()));
            } else if (comboBox.getId().equalsIgnoreCase("grouperVersion")) {
                comboBox.getItems().addAll(ComponentManager.getGrouperVersions());
            } else if (comboBox.getId().equalsIgnoreCase("grouperTable")) {
                comboBox.getItems().addAll(new Object[]{""});
            } else if (comboBox.getId().equalsIgnoreCase("tableColumns")) {
                comboBox.getItems().addAll(new Object[]{""});
            } else {
                int maxValue = 0;
                if (maxThreeValues.contains(comboBox.getId())) {
                    maxValue = 3;
                } else if (maxFourValues.contains(comboBox.getId())) {
                    maxValue = 4;
                } else if (maxFiveValues.contains(comboBox.getId())) {
                    maxValue = 5;
                } else if (maxSixValues.contains(comboBox.getId())) {
                    maxValue = 6;
                }
                for (int i = 0; i <= maxValue; ++i) {
                    values.add(FunctionalImpairments.getFunctionalImpairmentsList(comboBox.getId()).get(i).getDescription());
                }
            }
            comboBox.getItems().addAll(values.toArray());
            comboBox.getSelectionModel().select(0);
            comboBox.setAccessibleText((String)comboBox.getSelectionModel().getSelectedItem());
        }
    }

    public static <T> void setComboBox(ComboBox c, ObservableList<T> values) {
        c.setItems(values);
        c.setDisable(false);
        c.getSelectionModel().select(0);
    }

    public static void clearComboBox(ComboBox comboBox) {
        comboBox.setDisable(true);
        comboBox.getSelectionModel().select(0);
    }
}

