/*
 * Decompiled with CFR 0.152.
 */
package gov.cms.hh.v04223;

import gov.cms.hh.grouper.GrouperIF;
import gov.cms.hh.logic.specification.IsSpanClaim;
import java.time.LocalDate;
import java.time.ZoneId;
import java.time.temporal.ChronoUnit;
import java.util.Date;

public class IsSpanClaim_v04223
extends IsSpanClaim {
    public IsSpanClaim_v04223(String date) {
        super(date);
    }

    @Override
    public boolean isSatisfiedBy(GrouperIF gv) {
        return this.isDaysInRange(gv.getEndDate());
    }

    @Override
    protected boolean isDaysInRange(Date versionEnd) {
        if (this.getDate() == null) {
            return false;
        }
        LocalDate claimEndDate = this.getDate().toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate verEndDate = versionEnd.toInstant().atZone(ZoneId.systemDefault()).toLocalDate();
        long days = ChronoUnit.DAYS.between(verEndDate, claimEndDate);
        return days > 0L;
    }
}

