/* 
 * 
 * Home Health Grouper Software
 * 
 * Center for Medicare and Medicaid Services (CMS)
 * 
 * All code is provided as is.
 * 
 */
package gov.cms.hh.claim;

import gov.cms.hh.data.exchange.ClaimContainerIF;

/**  Convert claim container (PC API):
 *
 * 1.From Claim Container to Claim (internal claim object) format for grouping
 *  2. From Claim (internal claim) to Claim Container format for utility services
 * - populating results
 * - exporting claim back to fix format
 */
public interface ClaimAdapterIF {


    /** @param claimIn
     *
     * @return
     */
    ClaimContainerIF convert(ClaimIF claimIn);

    /**
     *
     * @param claimIn
     * @return
     */
    ClaimIF convert(final ClaimContainerIF claimIn);
    
}
